/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.config.Transformations;
import de.resolution.usersync.builtin.azure.AzureConnectorConfigurationImpl;
import de.resolution.usersync.builtin.gsuite.GSuiteConnectorConfigurationImpl;
import de.resolution.usersync.builtin.keycloak.KeycloakConnectorConfigurationImpl;
import de.resolution.usersync.builtin.okta.OktaConnectorConfigurationImpl;
import de.resolution.usersync.builtin.onelogin.OneLoginConnectorConfigurationImpl;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfigurationImpl;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AttributeTransformationMigrator {
    private static final List<ConnectorConfiguration> allConfigs = new ArrayList<AbstractConnectorConfigurationImpl>(Arrays.asList(new OktaConnectorConfigurationImpl(), new AzureConnectorConfigurationImpl(), new GSuiteConnectorConfigurationImpl(), new KeycloakConnectorConfigurationImpl(), new OneLoginConnectorConfigurationImpl(), new TestConnectorConfigurationImpl()));
    private static final List<String> allReadOnly = allConfigs.stream().map(ConnectorConfiguration::createDefaultAttributeTransformationConfigs).map(cfg -> cfg.stream().filter(AttributeTransformationConfig::isReadOnly)).flatMap(ff -> ff.map(config -> config.getTarget().getName())).collect(Collectors.toList());
    private static final List<String> allRequired = allConfigs.stream().map(ConnectorConfiguration::createDefaultAttributeTransformationConfigs).map(cfg -> cfg.stream().filter(AttributeTransformationConfig::isRequired)).flatMap(ff -> ff.map(config -> config.getTarget().getName())).collect(Collectors.toList());

    private AttributeTransformationMigrator() {
    }

    public static List<AttributeTransformationConfig> migrateAttributeTransformers(JsonNode attributeTransformersNode) {
        ArrayList<AttributeTransformationConfig> cfgList = new ArrayList<AttributeTransformationConfig>();
        if (attributeTransformersNode instanceof ArrayNode) {
            for (JsonNode current : attributeTransformersNode) {
                AttributeTransformationConfig tmp = AttributeTransformationMigrator.migrateSingleTransformer(current);
                cfgList.add(AttributeTransformationMigrator.migrateProfileOrPropertyMapping(tmp));
            }
        }
        return cfgList;
    }

    private static AttributeTransformationConfig migrateProfileOrPropertyMapping(AttributeTransformationConfig config) {
        if (config.getTarget().getType() != Target.Type.CROWD) {
            return config;
        }
        if (config.getTarget().getName().startsWith("JIRA.PROP.")) {
            return new AttributeTransformationConfig(config.getSource(), Target.createProfile(config.getTarget().getName().replace("JIRA.PROP.", "")), config.getTransformations(), false, false);
        }
        if (config.getTarget().getName().startsWith("CONFLUENCE.UD.")) {
            return new AttributeTransformationConfig(config.getSource(), Target.createProfile(config.getTarget().getName().replace("CONFLUENCE.UD.", "")), config.getTransformations(), false, false);
        }
        return config;
    }

    public static AttributeTransformationConfig migrateSingleTransformer(JsonNode attributeTransformerNode) {
        String targetName = attributeTransformerNode.get("applicationField").asText();
        Target target = targetName.equals("ATTR_NAME") || targetName.equals("ATTR_EMAIL") || targetName.equals("ATTR_FULLNAME") || targetName.equals("JIRA.ATTR_ORGANIZATIONS") || targetName.equals("JIRA.ATTR_ORGANIZATIONS_CREATE") ? new Target(Target.Type.SYSTEM, targetName) : new Target(Target.Type.CROWD, targetName);
        String connectorFieldExpression = attributeTransformerNode.get("connectorFieldExpression").asText();
        Source source2 = targetName.equals("JIRA.ATTR_ORGANIZATIONS_CREATE") ? (connectorFieldExpression.contains("true") ? Source.createGroovy("true") : Source.createGroovy("false")) : (connectorFieldExpression.contains("{") ? Source.createFieldCombiner(connectorFieldExpression) : Source.createSingle(connectorFieldExpression));
        Transformations transformations = null;
        JsonNode transformationsNode = attributeTransformerNode.get("transformations");
        if (transformationsNode instanceof ArrayNode) {
            transformations = new Transformations(false, null, null, null);
            ArrayList<RegexAndReplacement> regexAndReplacements = new ArrayList<RegexAndReplacement>();
            boolean enabled = false;
            for (JsonNode currentTransformation : transformationsNode) {
                enabled = true;
                String regex = currentTransformation.get("regex").asText();
                String replacement = currentTransformation.get("replacement").asText();
                regexAndReplacements.add(new RegexAndReplacement(regex, replacement));
            }
            if (enabled) {
                boolean dropUnmatched = attributeTransformerNode.get("dropUnmatched") != null && attributeTransformerNode.get("dropUnmatched").asBoolean();
                Transformations.DropOption dropOption = dropUnmatched ? Transformations.DropOption.DROP_USER_IF_NOT_APPLIED : Transformations.DropOption.NONE;
                transformations = new Transformations(false, new Transformations.RegexAndReplacementWrapper(true, regexAndReplacements, dropOption), null, null);
            }
        }
        return new AttributeTransformationConfig(source2, target, transformations, allReadOnly.contains(targetName), allRequired.contains(targetName));
    }
}

