/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.keycloak;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.keycloak.KeycloakConnector;
import de.resolution.usersync.builtin.keycloak.KeycloakConnectorConfiguration;
import de.resolution.usersync.builtin.keycloak.KeycloakConnectorConfigurationImpl;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractOAuthConnectorFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="keycloakConnectorFactory")
@JsonAutoDetect
public class KeycloakConnectorFactory
extends AbstractOAuthConnectorFactory<KeycloakConnector, KeycloakConnectorConfiguration> {
    static final String NAME = "Keycloak";
    private static final String DESCRIPTION = "Connector using the Keycloak REST API";

    @Inject
    public KeycloakConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public KeycloakConnector create(@Nonnull KeycloakConnectorConfiguration keycloakConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new KeycloakConnector(this.connectorService, this.atlasUserAdapter, keycloakConnectorConfiguration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public KeycloakConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        KeycloakConnectorConfigurationImpl mutableConfig = new KeycloakConnectorConfigurationImpl();
        mutableConfig.setName("new Keycloak");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public Class<KeycloakConnector> getConnectorClass() {
        return KeycloakConnector.class;
    }

    @Override
    @Nonnull
    public Class<KeycloakConnectorConfiguration> getConfigurationClass() {
        return KeycloakConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public String getSingleSyncInputTitle() {
        return "Keycloak ID or username";
    }

    @Override
    @Nonnull
    public String getSingleSyncInputDescription() {
        return "Please enter the ID or the username of the Keycloak user to update.";
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editKeycloakConnector.json";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull KeycloakConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        if (StringUtil.isNullOrEmpty(config.getBaseUrl())) {
            validationResult.add("baseUrl", "You must set a base url");
        }
        if (StringUtil.isNullOrEmpty(config.getRealm())) {
            validationResult.add("realm", "You must set a realm");
        }
        if (config.getBatchSize() <= 0) {
            validationResult.add("batchSize", "The value must be greater than 0");
        }
        return validationResult;
    }

    @Override
    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        attributeTransformationConfigs.add(KeycloakConnectorConfigurationImpl.ACTIVE_TRANSFORMATION);
    }
}

