/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.commons.data.StructuredData;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.exception.UserFindFailedException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FindUserResult {
    private final StructuredData attributesFromConnector;
    private final Exception exception;
    private final SyncSingleUserResult.Status status;

    public static FindUserResult filtered(StructuredData attributesFromConnector) {
        return new FindUserResult(SyncSingleUserResult.Status.FILTERED, attributesFromConnector, null);
    }

    public static FindUserResult preFiltered(StructuredData attributesFromConnector) {
        return new FindUserResult(SyncSingleUserResult.Status.PREFILTERED, attributesFromConnector, null);
    }

    public static FindUserResult found(StructuredData attributesFromConnector) {
        return new FindUserResult(SyncSingleUserResult.Status.FOUND, attributesFromConnector, null);
    }

    public static FindUserResult failed(Exception ex) {
        return new FindUserResult(SyncSingleUserResult.Status.FAILED, null, ex);
    }

    public static FindUserResult failed(@Nullable String message) {
        return new FindUserResult(SyncSingleUserResult.Status.FAILED, null, new UserFindFailedException(message));
    }

    public static FindUserResult notFound() {
        return new FindUserResult(SyncSingleUserResult.Status.NOT_FOUND, null, null);
    }

    public static FindUserResult notUnique() {
        return new FindUserResult(SyncSingleUserResult.Status.NOT_UNIQUE, null, null);
    }

    private FindUserResult(@Nonnull SyncSingleUserResult.Status status, @Nullable StructuredData attributesFromConnector, @Nullable Exception exception) {
        this.status = status;
        this.attributesFromConnector = attributesFromConnector == null ? StructuredData.create() : attributesFromConnector;
        this.exception = exception;
    }

    @Nonnull
    public StructuredData getAttributesFromConnector() {
        return this.attributesFromConnector;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public SyncSingleUserResult.Status getStatus() {
        return this.status;
    }
}

