/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.impl.GroovyAttributeTransformerScript;
import de.resolution.retransform.impl.TransformationResultImpl;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingPropertyException;
import groovy.transform.ThreadInterrupt;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyAttributeTransformer
implements AttributeTransformer {
    private static final Logger logger = LoggerFactory.getLogger(GroovyAttributeTransformer.class);
    public static final long DEFAULT_TIMEOUT = 2000L;
    @Nonnull
    private final String script;
    private final long timeout;
    @Nullable
    private final String defaultTopLevelKey;
    @Nullable
    private final AtlasUserAdapter atlasUserAdapter;
    private String compilationErrorMessage;
    private Class<GroovyAttributeTransformerScript> scriptClass;
    private static final String MAPPING = "mapping";
    private static final String GROOVY_RESULT = "groovyResult";
    private static final String MAPPING_DROP = "drop";

    public GroovyAttributeTransformer(@Nonnull String script, long timeout2, @Nullable String defaultTopLevelKey, @Nullable AtlasUserAdapter atlasUserAdapter) {
        block14: {
            this.script = script;
            this.timeout = timeout2;
            this.defaultTopLevelKey = defaultTopLevelKey;
            this.atlasUserAdapter = atlasUserAdapter;
            CompilerConfiguration compilerConfig = new CompilerConfiguration();
            compilerConfig.setScriptBaseClass("de.resolution.retransform.impl.GroovyAttributeTransformerScript");
            ImportCustomizer importCustomizer = new ImportCustomizer();
            importCustomizer.addStarImports("de.resolution.retransform.api", "de.resolution.atlasuser.api.user");
            compilerConfig.addCompilationCustomizers(new ASTTransformationCustomizer(ThreadInterrupt.class), importCustomizer);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader(), compilerConfig);){
                    this.scriptClass = groovyClassLoader.parseClass(script);
                    this.compilationErrorMessage = null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassCastException | CompilationFailedException e) {
                this.compilationErrorMessage = e.getMessage();
                this.scriptClass = null;
            }
            try {
                this.transform(StructuredData.create());
                logger.trace("--- Warmup-Run is done ---");
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block14;
                logger.trace("Initial Execution threw Exception, this  {}:{} in initial execution, this should be ignored", (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            }
        }
    }

    public GroovyAttributeTransformer(String script, long timeout2, String defaultTopLevelKey) {
        this(script, timeout2, defaultTopLevelKey, null);
    }

    public GroovyAttributeTransformer(String script, String defaultTopLevelKey, AtlasUserAdapter atlasUserAdapter) {
        this(script, 2000L, defaultTopLevelKey, atlasUserAdapter);
    }

    public GroovyAttributeTransformer(String script, String defaultTopLevelKey) {
        this(script, 2000L, defaultTopLevelKey, null);
    }

    @Override
    @Nonnull
    public AttributeTransformationResult transform(@Nonnull StructuredData attributeData) throws TransformationFailedException {
        if (!attributeData.isMap()) {
            throw new TransformationFailedException("Input is no MapStructuredData");
        }
        MapStructuredData attributeMap = attributeData.deepCopy().asMap();
        if (this.scriptClass == null) {
            throw new TransformationFailedException("Compiling script failed: " + this.compilationErrorMessage);
        }
        try {
            StructuredData topLevelAttributes;
            GroovyAttributeTransformerScript scriptInstance = this.scriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            scriptInstance.setAtlasUserAdapter(this.atlasUserAdapter);
            Binding binding = new Binding();
            if (this.getDefaultTopLevelKey() != null && (topLevelAttributes = attributeMap.get(this.getDefaultTopLevelKey())) != null) {
                ((Map)((Object)topLevelAttributes)).forEach((k, v) -> binding.setProperty(String.valueOf(k), v));
            }
            attributeMap.forEach((BiConsumer<? super String, ? super StructuredData>)((BiConsumer<String, StructuredData>)(k, v) -> binding.setProperty(String.valueOf(k), v)));
            binding.setProperty(MAPPING, attributeMap);
            scriptInstance.setBinding(binding);
            CompletableFuture<Object> cf = CompletableFuture.supplyAsync(scriptInstance::run);
            try {
                List<String> resultList;
                Object mappingObj;
                Object result = cf.get(this.timeout, TimeUnit.SECONDS);
                if (binding.hasVariable(MAPPING) && (mappingObj = binding.getVariable(MAPPING)) instanceof Map) {
                    Map mapping = (Map)mappingObj;
                    if (mapping.containsKey(GROOVY_RESULT)) {
                        result = mapping.get(GROOVY_RESULT);
                    }
                    if (mapping.containsKey(MAPPING_DROP) && mapping.get(MAPPING_DROP) != null && mapping.get(MAPPING_DROP).equals(true)) {
                        return AttributeTransformationResult.create(Collections.emptyList(), false, true, "User is dropped in transformation");
                    }
                }
                if (result == null) {
                    return new TransformationResultImpl(Collections.emptyList(), false, false);
                }
                if (result instanceof StructuredData && ((StructuredData)result).isEmpty()) {
                    return new TransformationResultImpl(Collections.emptyList(), false, false);
                }
                if (result instanceof AttributeTransformationResult) {
                    return (AttributeTransformationResult)result;
                }
                if (result instanceof Collection) {
                    Object element;
                    Collection resultCollection = (Collection)result;
                    if (resultCollection.size() == 1 && (element = resultCollection.iterator().next()) instanceof GroovyAttributeTransformerScript.DropResult) {
                        return (GroovyAttributeTransformerScript.DropResult)element;
                    }
                    resultList = resultCollection.stream().map(String::valueOf).collect(Collectors.toList());
                } else {
                    resultList = Collections.singletonList(String.valueOf(result));
                }
                return new TransformationResultImpl(resultList, false, false);
            }
            catch (ExecutionException e) {
                throw new TransformationFailedException("Executing script failed", e.getCause());
            }
            catch (MissingPropertyException missingPropertyException) {
                return new TransformationResultImpl(Collections.emptyList(), true, false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TransformationFailedException("Interrupted waiting for the script to complete.", e);
            }
            catch (Exception e) {
                throw new TransformationFailedException("Executing script failed", e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TransformationFailedException("Creating script-instance failed", e);
        }
    }

    @Nonnull
    public String getScript() {
        return this.script;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public ValidationResult validate() {
        ValidationResult validationResult = ValidationResult.create();
        if (this.compilationErrorMessage != null) {
            validationResult.addError(this.compilationErrorMessage);
        }
        if (this.script.contains("mapping.groovyResult")) {
            validationResult.addWarning("The script seems to be in the old style using 'mapping.groovyResult'. It should be updated.");
        }
        return validationResult;
    }

    @Nullable
    public String getDefaultTopLevelKey() {
        return this.defaultTopLevelKey;
    }
}

