/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractKeyBasedAttributeTransformer
implements AttributeTransformer {
    private final String defaultTopLevelKey;
    private final boolean splitKey;

    protected AbstractKeyBasedAttributeTransformer(boolean splitKey, String defaultTopLevelKey) {
        this.splitKey = splitKey;
        this.defaultTopLevelKey = defaultTopLevelKey;
    }

    public String getDefaultTopLevelKey() {
        return this.defaultTopLevelKey;
    }

    public boolean isSplitKey() {
        return this.splitKey;
    }

    @Override
    public ValidationResult validate() {
        return ValidationResult.create();
    }

    @Nonnull
    public static AttributeTransformationResult createAttributeTransformationResult(@Nonnull ReadResult readResult) {
        if (!readResult.isKeyPresent()) {
            return AttributeTransformationResult.createDrop("Key " + readResult.getKey() + " is not present.");
        }
        if (readResult.getData() == null) {
            return AttributeTransformationResult.createEmpty("Key " + readResult.getKey() + " has null as value.");
        }
        if (readResult.getData().isEmpty()) {
            return AttributeTransformationResult.create(Collections.emptyList(), false, false, "Data under key is empty.");
        }
        if (readResult.getData().isList()) {
            return AttributeTransformationResult.create(readResult.getData().asStringList(), false, false, null);
        }
        return AttributeTransformationResult.create(Collections.singletonList(readResult.getData().asString()), false, false, null);
    }

    public AttributeTransformationResult transformSingleKey(String key, StructuredData data) throws TransformationFailedException {
        try {
            ReadResult readResult = AbstractKeyBasedAttributeTransformer.read(key, data, this.getDefaultTopLevelKey(), this.isSplitKey());
            return AbstractKeyBasedAttributeTransformer.createAttributeTransformationResult(readResult);
        }
        catch (Exception e) {
            throw new TransformationFailedException(e);
        }
    }

    public static ReadResult read(@Nonnull String key, @Nonnull StructuredData data, @Nullable String defaultTopLevelKey, boolean splitKey) {
        MapStructuredData mapStructuredData = data.asMap();
        MapStructuredData dataToWorkWith = defaultTopLevelKey != null && !defaultTopLevelKey.trim().isEmpty() ? (mapStructuredData.containsKey(defaultTopLevelKey) ? mapStructuredData.get(defaultTopLevelKey).asMap() : mapStructuredData) : mapStructuredData;
        if (splitKey) {
            return AbstractKeyBasedAttributeTransformer.readWithSplittingTheKey(key, dataToWorkWith);
        }
        if (!dataToWorkWith.containsKey(key)) {
            return new ReadResult(key, null, false);
        }
        StructuredData dataToReturn = dataToWorkWith.get(key);
        return new ReadResult(key, dataToReturn, true);
    }

    @Nonnull
    private static ReadResult readWithSplittingTheKey(@Nonnull String key, @Nonnull MapStructuredData data) {
        ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(key.split("\\.")));
        return AbstractKeyBasedAttributeTransformer.readPath(keyList, data);
    }

    @Nonnull
    private static ReadResult readPath(@Nonnull List<String> keys2, @Nonnull MapStructuredData data) {
        if (!data.hasKey(keys2)) {
            return new ReadResult(String.join((CharSequence)".", keys2), data, false);
        }
        String firstKey = keys2.remove(0);
        if (!data.containsKey(firstKey)) {
            return new ReadResult(firstKey, null, false);
        }
        StructuredData dataUnderKey = data.get(firstKey);
        if (dataUnderKey == null) {
            if (keys2.isEmpty()) {
                return new ReadResult(firstKey, null, true);
            }
            return new ReadResult(firstKey, data, false);
        }
        if (keys2.isEmpty()) {
            return new ReadResult(firstKey, dataUnderKey, true);
        }
        return AbstractKeyBasedAttributeTransformer.readPath(keys2, dataUnderKey.asMap());
    }

    public static class ReadResult {
        private final String key;
        private final StructuredData data;
        private final boolean keyPresent;

        public ReadResult(@Nonnull String key, @Nullable StructuredData data, boolean keyPresent) {
            this.key = key;
            this.data = data;
            this.keyPresent = keyPresent;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        @Nullable
        public StructuredData getData() {
            return this.data;
        }

        public boolean isKeyPresent() {
            return this.keyPresent;
        }
    }
}

