/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.jira;

import com.atlassian.crowd.model.user.User;
import com.atlassian.jira.bc.user.UserPropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.api.JiraServiceDeskApi;
import de.resolution.atlascompat.api.exception.AtlasCompatApiException;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.HostProduct;
import de.resolution.atlasuser.api.HostProductProvider;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.atlasuser.impl.user.jira.JiraProfilePictureAdapter;
import de.resolution.atlasuser.impl.user.jira.JiraUtil;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraApplicationAttributeAdapter
implements ApplicationAttributeAdapter,
HostProductProvider {
    private static final Logger logger = LoggerFactory.getLogger(JiraApplicationAttributeAdapter.class);
    private static final String PREFIX_PROPERTIES = "PROP.";
    private static final String JIRA_PREFIX_PROPERTIES = "jira.meta.";
    private static final String PREFIX_HIDDEN_PROPERTY = "HIDDEN.";
    private static final String JIRA_PREFIX_HIDDEN_PROPERTY = "atlasuser.";
    public static final String PREFIX_ENTITY_PROPERTIES = "EPROP.";
    private final UserManager jiraUserManager;
    private final UserPropertyManager userPropertyManager;
    private final UserPropertyService userPropertyService;
    private final AtlasCompatApiFactory atlasCompatApiFactory;
    private final JiraUtil jiraUtil;
    private final CommunardoUserProfileAdapter communardoUserProfileAdapter;
    private final JiraProfilePictureAdapter jiraProfilePictureAdapter;

    @Autowired
    public JiraApplicationAttributeAdapter(@JiraImport(value="jiraUserManager") UserManager jiraUserManager, @JiraImport UserPropertyManager userPropertyManager, @JiraImport UserPropertyService userPropertyService, AtlasCompatApiFactory atlasCompatApiFactory, JiraUtil jiraUtil, CommunardoUserProfileAdapter communardoUserProfileAdapter, JiraProfilePictureAdapter jiraProfilePictureAdapter) {
        this.jiraUserManager = jiraUserManager;
        this.userPropertyManager = userPropertyManager;
        this.userPropertyService = userPropertyService;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
        this.jiraUtil = jiraUtil;
        this.communardoUserProfileAdapter = communardoUserProfileAdapter;
        this.jiraProfilePictureAdapter = jiraProfilePictureAdapter;
    }

    @Override
    public HostProduct getHostProduct() {
        return HostProduct.JIRA;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public String getUsernameForKey(@Nonnull String key) {
        ApplicationUser applicationUser = this.jiraUserManager.getUserByKey(key);
        if (applicationUser == null) {
            return null;
        }
        return applicationUser.getUsername();
    }

    @Override
    public AtlasUserBuilder readApplicationAttributes(User crowdUser, AtlasUserBuilder atlasUserBuilder, @Nullable Collection<String> knownKeys) {
        ApplicationUser applicationUser = this.jiraUserManager.findUserInDirectory(crowdUser.getName(), Long.valueOf(crowdUser.getDirectoryId()));
        if (applicationUser != null) {
            atlasUserBuilder.with("ATTR_USER_KEY", applicationUser.getKey());
            PropertySet propertySet = this.userPropertyManager.getPropertySet(applicationUser);
            for (Object keyObj : propertySet.getKeys(5)) {
                String value;
                String key = (String)keyObj;
                if (key.startsWith(JIRA_PREFIX_PROPERTIES)) {
                    value = propertySet.getString(key);
                    if (value == null) continue;
                    String shortenedKey = key.substring(JIRA_PREFIX_PROPERTIES.length());
                    atlasUserBuilder.with("JIRA.PROP." + shortenedKey, value);
                    continue;
                }
                if (key.startsWith(JIRA_PREFIX_HIDDEN_PROPERTY)) {
                    value = propertySet.getString(key);
                    String shortendedKey = key.substring(JIRA_PREFIX_HIDDEN_PROPERTY.length());
                    atlasUserBuilder.with("JIRA.HIDDEN." + shortendedKey, value);
                    continue;
                }
                logger.debug("Skipping property {}", (Object)key);
            }
            this.readEntityProperties(atlasUserBuilder, applicationUser);
            this.communardoUserProfileAdapter.readProfileAttributes(applicationUser.getKey(), atlasUserBuilder);
            this.jiraProfilePictureAdapter.readProfilePictureAttributes(applicationUser.getKey(), atlasUserBuilder);
        }
        return atlasUserBuilder;
    }

    private void readEntityProperties(AtlasUserBuilder atlasUserBuilder, ApplicationUser applicationUser) {
        ApplicationUser execUser = this.jiraUtil.findExecutionUser();
        EntityPropertyService.PropertyKeys keys2 = this.userPropertyService.getPropertiesKeys(execUser, applicationUser.getKey());
        for (String propertyKey : keys2.getKeys()) {
            EntityPropertyService.PropertyResult propertyResult = this.userPropertyService.getProperty(execUser, applicationUser.getKey(), propertyKey);
            EntityProperty entityProperty = (EntityProperty)propertyResult.getEntityProperty().getOrNull();
            if (entityProperty != null) {
                String propertyValue = entityProperty.getValue();
                String completeKey = "JIRA.EPROP." + propertyKey;
                atlasUserBuilder.with(completeKey, propertyValue);
                continue;
            }
            logger.warn("key {} has null-value for user {}", (Object)propertyKey, (Object)applicationUser.getUsername());
        }
    }

    private void updateEntityProperties(AtlasUser atlasUser, @Nonnull ApplicationUser applicationUser, AtlasUserResultBuilder atlasUserResultBuilder) {
        ApplicationUser execUser = this.jiraUtil.findExecutionUser();
        atlasUser.getAttributeKeys().stream().filter(key -> key.startsWith("JIRA.EPROP.")).forEach(key -> {
            String value = atlasUser.get((String)key).orElse(null);
            String propertyKey = key.substring("JIRA.EPROP.".length());
            if (value != null) {
                String currentValue = null;
                EntityPropertyService.PropertyResult propertyResult = this.userPropertyService.getProperty(execUser, applicationUser.getKey(), propertyKey);
                Option entityPropertyOpt = propertyResult.getEntityProperty();
                if (entityPropertyOpt.isDefined()) {
                    currentValue = ((EntityProperty)entityPropertyOpt.get()).getValue();
                }
                if (!Objects.equals(value, currentValue)) {
                    EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(value, propertyKey);
                    EntityPropertyService.SetPropertyValidationResult validationResult = this.userPropertyService.validateSetProperty(execUser, applicationUser.getKey(), propertyInput);
                    if (validationResult.isValid()) {
                        this.userPropertyService.setProperty(execUser, validationResult);
                        atlasUserResultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                    } else {
                        atlasUserResultBuilder.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
                        atlasUserResultBuilder.errorString(key + ": " + String.join((CharSequence)",", validationResult.getErrorCollection().getErrorMessages()));
                    }
                }
            } else if (this.userPropertyService.getPropertiesKeys(execUser, applicationUser.getKey()).getKeys().contains(propertyKey)) {
                EntityPropertyService.DeletePropertyValidationResult validationResult = this.userPropertyService.validateDeleteProperty(execUser, applicationUser.getKey(), propertyKey);
                if (validationResult.isValid()) {
                    this.userPropertyService.deleteProperty(execUser, validationResult);
                    atlasUserResultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                } else {
                    atlasUserResultBuilder.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
                    atlasUserResultBuilder.errorString(key + ": " + String.join((CharSequence)",", validationResult.getErrorCollection().getErrorMessages()));
                }
            }
        });
    }

    @Override
    public AtlasUserResultBuilder updateApplicationAttributes(User crowdUser, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder) {
        ApplicationUser applicationUser = this.jiraUserManager.findUserInDirectory(crowdUser.getName(), Long.valueOf(crowdUser.getDirectoryId()));
        if (applicationUser != null) {
            this.updatePropertySet(atlasUser, applicationUser, resultBuilder);
            if (resultBuilder.isFailure()) {
                return resultBuilder;
            }
            this.updateEntityProperties(atlasUser, applicationUser, resultBuilder);
            if (resultBuilder.isFailure()) {
                return resultBuilder;
            }
            this.updateSdOrganizations(atlasUser, applicationUser, resultBuilder);
            if (resultBuilder.isFailure()) {
                return resultBuilder;
            }
            this.communardoUserProfileAdapter.updateProfileAttributes(applicationUser.getKey(), atlasUser, resultBuilder);
            this.jiraProfilePictureAdapter.updateProfilePicture(atlasUser, applicationUser.getKey(), resultBuilder);
        }
        return resultBuilder;
    }

    private void updatePropertySet(@Nonnull AtlasUser atlasUser, @Nonnull ApplicationUser applicationUser, AtlasUserResultBuilder resultBuilder) {
        try {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(applicationUser);
            atlasUser.getAttributeKeys().stream().filter(key -> key.startsWith("JIRA.")).forEach(key -> this.updateProperty(propertySet, (String)key, atlasUser, resultBuilder));
        }
        catch (PropertyException | IllegalArgumentException | IllegalStateException e) {
            resultBuilder.errorString("Reading PropertySet failed: " + e.getMessage()).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
    }

    private void updateProperty(PropertySet propertySet, String key, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder) {
        if (!key.startsWith("JIRA.PROP.") && !key.startsWith("JIRA.HIDDEN.")) {
            logger.debug("Skipping attribute {}", (Object)key);
            return;
        }
        String propertyKey = key.startsWith("JIRA.PROP.") ? JIRA_PREFIX_PROPERTIES + key.substring("JIRA.PROP.".length()) : JIRA_PREFIX_HIDDEN_PROPERTY + key.substring("JIRA.HIDDEN.".length());
        String propertyValue = propertySet.getString(propertyKey);
        Optional<String> valueOpt = atlasUser.get(key);
        if (valueOpt.isPresent()) {
            String value = valueOpt.get();
            if (!Objects.equals(value, propertyValue)) {
                logger.debug("{}/{} Updating: {} with {}", new Object[]{key, propertyKey, propertyValue, value});
                propertySet.setString(propertyKey, value);
                if (!resultBuilder.getOperation().equals((Object)AtlasUserResult.Operation.ADDED)) {
                    resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                }
            } else {
                logger.debug("{}/{} No change necessary: {} {}", new Object[]{key, propertyKey, value, propertyValue});
            }
        } else {
            logger.debug("Removing property {}/{}", (Object)key, (Object)propertyKey);
            propertySet.remove(propertyKey);
        }
    }

    private void updateSdOrganizations(@Nonnull AtlasUser atlasUser, @Nonnull ApplicationUser applicationUser, @Nonnull AtlasUserResultBuilder resultBuilder) {
        Set<String> organizations = atlasUser.getAttributeValues("JIRA.ATTR_ORGANIZATIONS");
        if (organizations.isEmpty()) {
            return;
        }
        Optional<JiraServiceDeskApi> jiraServiceDeskApi = this.atlasCompatApiFactory.getJiraServiceDeskApi();
        if (!jiraServiceDeskApi.isPresent()) {
            resultBuilder.addMessage("Assigning organization failed because serviceDeskManagerService is null.");
            return;
        }
        ApplicationUser adminUser = this.jiraUtil.findExecutionUser(true);
        if (adminUser == null) {
            resultBuilder.addMessage("No admin user found with permission for organization assignment.");
            return;
        }
        boolean createOrganizations = Boolean.parseBoolean(atlasUser.get("JIRA.ATTR_ORGANIZATIONS_CREATE").orElse(String.valueOf(false)));
        for (String organization : organizations) {
            try {
                jiraServiceDeskApi.get().assignUserToOrganization(applicationUser.getKey(), adminUser.getKey(), organization, createOrganizations);
            }
            catch (AtlasCompatApiException e) {
                logger.info("Organization '{}' was not assigned to user '{}'", new Object[]{organization, applicationUser.getName(), e});
                resultBuilder.addMessage("No admin user found with permission for organization assignment.");
            }
        }
    }
}

