/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.confluence;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.ThreadLocalProfilePictureCache;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AbstractProfilePictureAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.confluence.ConfluenceUtil;
import de.resolution.commons.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceProfilePictureAdapter
extends AbstractProfilePictureAdapter {
    public static final String DEFAULT_AVATAR_FILENAME = "default.svg";
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceProfilePictureAdapter.class);
    private final AttachmentManager attachmentManager;
    private final UserAccessor userAccessor;
    private final TransactionTemplate transactionTemplate;
    private final PersonalInformationManager personalInformationManager;
    private final ConfluenceUtil confluenceUtil;

    @Autowired
    public ConfluenceProfilePictureAdapter(@ConfluenceImport AttachmentManager attachmentManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport TransactionTemplate transactionTemplate, @ConfluenceImport PersonalInformationManager personalInformationManager, ConfluenceUtil confluenceUtil) {
        this.attachmentManager = attachmentManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.personalInformationManager = personalInformationManager;
        this.confluenceUtil = confluenceUtil;
    }

    @Override
    public void updateProfilePicture(@Nonnull AtlasUser atlasUser, @Nonnull String userKey, @Nonnull AtlasUserResultBuilder resultBuilder) {
        if (!atlasUser.containsKey("ATTR_PROFILE_PICTURE_DATA")) {
            logger.debug("No profile picture data supplied, skipping ConfluenceProfilePictureAdapter.");
            return;
        }
        Optional<String> optionalProfilePictureData = atlasUser.get("ATTR_PROFILE_PICTURE_DATA");
        ConfluenceUser applicationUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (!optionalProfilePictureData.isPresent() || StringUtil.isNullOrEmpty(optionalProfilePictureData.get())) {
            logger.debug("Empty profile picture supplied, setting default avatar.");
            this.assignAttachmentIfExists(DEFAULT_AVATAR_FILENAME, applicationUser, resultBuilder);
            this.cleanupUnusedAttachments(applicationUser, null, resultBuilder);
            return;
        }
        String[] dataComponents = optionalProfilePictureData.get().split(";");
        if (dataComponents.length != 2) {
            logger.debug("Malformed data supplied");
            return;
        }
        String hash = dataComponents[0];
        if (StringUtil.isNullOrEmpty(hash)) {
            logger.debug("Empty hash supplied");
            return;
        }
        String avatarBase64 = dataComponents[1];
        if (StringUtil.isNullOrEmpty(avatarBase64)) {
            logger.debug("Empty base64 supplied");
            return;
        }
        String fileName = this.getFilename(hash);
        if (this.assignAttachmentIfExists(fileName, applicationUser, resultBuilder)) {
            logger.debug("Existing avatar was assigned");
            return;
        }
        Attachment attachment = (Attachment)this.transactionTemplate.execute(() -> {
            try {
                return this.createAttachment(applicationUser, avatarBase64, fileName);
            }
            catch (IOException e) {
                resultBuilder.addMessage(e.getMessage()).exceptionInfo(ExceptionInfo.from(e)).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
                return null;
            }
        });
        if (attachment != null) {
            this.assignAttachment(attachment, applicationUser, resultBuilder);
        }
        this.cleanupUnusedAttachments(applicationUser, fileName, resultBuilder);
    }

    private boolean assignAttachmentIfExists(String filename, ConfluenceUser applicationUser, AtlasUserResultBuilder resultBuilder) {
        String filenameOfAssignedProfilePicture = this.getFilenameOfAssignedProfilePicture(applicationUser.getKey().getStringValue());
        if (filenameOfAssignedProfilePicture != null && filenameOfAssignedProfilePicture.startsWith(filename)) {
            return true;
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)applicationUser);
        List latestVersionsOfAttachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)personalInformation);
        for (Attachment latestVersionsOfAttachment : latestVersionsOfAttachments) {
            String attachmentFileName = latestVersionsOfAttachment.getFileName();
            if (!attachmentFileName.startsWith(filename)) continue;
            this.assignAttachment(latestVersionsOfAttachment, applicationUser, resultBuilder);
            return true;
        }
        return false;
    }

    private void cleanupUnusedAttachments(ConfluenceUser applicationUser, String avatarToKeep, AtlasUserResultBuilder resultBuilder) {
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)applicationUser);
        List latestVersionsOfAttachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)personalInformation);
        for (Attachment attachment : latestVersionsOfAttachments) {
            if (!attachment.getFileName().startsWith("atlas-user-") || avatarToKeep != null && attachment.getFileName().startsWith(avatarToKeep)) continue;
            logger.debug("Remove attachment with filename `{}`", (Object)attachment.getFileName());
            this.attachmentManager.removeAttachmentFromServer(attachment);
            resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
        }
    }

    private Attachment createAttachment(ConfluenceUser applicationUser, String avatarBase64, String fileName) throws IOException {
        String mimeType = this.detectMimeType(avatarBase64);
        byte[] image = Base64.getDecoder().decode(avatarBase64);
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)applicationUser);
        Attachment attachment = new Attachment();
        attachment.setVersion(1);
        attachment.setMediaType(mimeType);
        attachment.setFileName(fileName);
        attachment.setVersionComment("Uploaded Profile Picture");
        attachment.setFileSize((long)image.length);
        attachment.setContainer((ContentEntityObject)personalInformation);
        try (ByteArrayInputStream is = new ByteArrayInputStream(image);){
            this.attachmentManager.saveAttachment(attachment, null, (InputStream)is);
        }
        catch (IOException e) {
            logger.debug("Error saving attachment data: {} ", (Object)e.getMessage(), (Object)e);
        }
        return attachment;
    }

    private void assignAttachment(Attachment attachment, ConfluenceUser applicationUser, AtlasUserResultBuilder resultBuilder) {
        logger.debug("Setting custom avatar {} for user {}", (Object)attachment.getFileName(), (Object)applicationUser.getName());
        try (AutoCloseable ac = AuthenticatedUserThreadLocal.asUser((ConfluenceUser)this.confluenceUtil.findExecutionUser());){
            this.userAccessor.setUserProfilePicture((User)applicationUser, attachment);
        }
        catch (Exception e) {
            logger.warn("Failed setting profile picture", (Throwable)e);
        }
        ThreadLocalProfilePictureCache.cacheHasProfilePicture((User)applicationUser, (ProfilePictureInfo)new ProfilePictureInfo(attachment));
        if (Objects.equals(attachment.getFileName(), this.getFilenameOfAssignedProfilePicture(applicationUser.getKey().getStringValue()))) {
            logger.debug("Profile picture was added or updated");
            resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
        } else {
            logger.debug("Profile picture was not added or updated");
        }
    }

    @Override
    public void readProfilePictureAttributes(@Nonnull String userKey, @Nonnull AtlasUserBuilder atlasUserBuilder) {
        String filenameOfAssignedProfilePicture = this.getFilenameOfAssignedProfilePicture(userKey);
        if (filenameOfAssignedProfilePicture != null) {
            atlasUserBuilder.with("ATTR_PROFILE_PICTURE_FILENAME", filenameOfAssignedProfilePicture);
        }
    }

    private String getFilenameOfAssignedProfilePicture(String userKey) {
        ConfluenceUser applicationUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (applicationUser == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not load user profile picture filename because ConfluenceUser is null.");
            }
            return null;
        }
        ProfilePictureInfo userProfilePicture = this.userAccessor.getUserProfilePicture((User)applicationUser);
        if (userProfilePicture == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not load user profile picture filename because no profile picture is assigned.");
            }
            return null;
        }
        String fileName = userProfilePicture.getFileName();
        if (logger.isDebugEnabled()) {
            logger.debug("Current profile picture filename is: {}", (Object)fileName);
        }
        return fileName;
    }
}

