/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserValidator;
import java.util.Optional;

public abstract class DefaultAtlasUserValidator
implements AtlasUserValidator {
    @Override
    public void validateForCreate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        this.requireNotEmpty(atlasUser, "ATTR_NAME");
        this.requireNotEmpty(atlasUser, "ATTR_EMAIL");
        this.requireAnyNotEmpty(atlasUser, "ATTR_FULLNAME", "ATTR_FIRSTNAME", "ATTR_LASTNAME");
    }

    @Override
    public void validateForUpdate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        String findByAttributeName = atlasUser.getReference().getFindByAttributeName();
        String findByAttributeValue = atlasUser.getReference().getFindByAttributeValue();
        Optional<String> optionalAttributeValue = atlasUser.get(findByAttributeName);
        if (optionalAttributeValue.isPresent() && !optionalAttributeValue.get().equals(findByAttributeValue)) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), findByAttributeName, findByAttributeValue, "findByAttribute must not be updated");
        }
        this.requireNotEmptyIfPresent(atlasUser, "ATTR_EMAIL");
        this.requireNotEmptyIfPresent(atlasUser, "ATTR_NAME");
    }

    protected void requireNotEmptyIfPresent(AtlasUser atlasUser, String attributeName) throws AtlasUserValidationFailedException {
        Optional<String> opt = atlasUser.get(attributeName);
        if (opt.isPresent() && opt.get().trim().isEmpty()) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), attributeName, opt.get(), "Must not be empty if present");
        }
    }

    protected void requireNotEmpty(AtlasUser atlasUser, String attributeName) throws AtlasUserValidationFailedException {
        String value = atlasUser.get(attributeName).orElse(null);
        if (value == null) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), attributeName, null, "must not be null");
        }
        if (value.isEmpty()) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), attributeName, value, "must not be empty");
        }
    }

    protected void requireAnyNotEmpty(AtlasUser atlasUser, String ... attributeNames) throws AtlasUserValidationFailedException {
        for (String attributeName : attributeNames) {
            String value = atlasUser.get(attributeName).orElse(null);
            if (value == null || value.isEmpty()) continue;
            return;
        }
        throw new AtlasUserValidationFailedException(atlasUser.getReference(), String.join((CharSequence)",", attributeNames), null, "at least one attribute needs to be set");
    }
}

