/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.impl.AoNotification;
import de.resolution.usersync.impl.NotificationImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={NotificationService.class})
public class AoBasedNotificationService
implements NotificationService {
    private final ActiveObjects ao;
    private static final String QUERY_STRING_FOR_UNIQUE = "CONTEXT_ID = ? AND MESSAGE_ID = ?";

    @Autowired
    public AoBasedNotificationService(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void add(@Nonnull Notification notification) {
        this.ao.executeInTransaction(() -> {
            AoNotification[] existingList = (AoNotification[])this.ao.find(AoNotification.class, Query.select().where(QUERY_STRING_FOR_UNIQUE, new Object[]{notification.getContextId(), notification.getMessageId()}));
            if (existingList.length > 0) {
                if (existingList.length > 1) {
                    throw new TooManyEntriesException(notification.getContextId(), notification.getMessageId(), existingList.length);
                }
                AoNotification existing = existingList[0];
                existing.setData(notification.getMessage());
                existing.setLevel(String.valueOf((Object)notification.getLevel()));
                existing.save();
                return existing;
            }
            return (AoNotification)this.ao.create(AoNotification.class, new DBParam[]{new DBParam("LEVEL", (Object)String.valueOf((Object)notification.getLevel())), new DBParam("DATA", (Object)notification.getMessage()), new DBParam("CONTEXT_ID", (Object)notification.getContextId()), new DBParam("MESSAGE_ID", (Object)notification.getMessageId())});
        });
    }

    @Override
    @Nullable
    public Notification get(@Nonnull String contextId, @Nonnull String messageId) {
        return (Notification)this.ao.executeInTransaction(() -> {
            AoNotification[] existingList = (AoNotification[])this.ao.find(AoNotification.class, Query.select().where(QUERY_STRING_FOR_UNIQUE, new Object[]{contextId, messageId}));
            if (existingList.length == 0) {
                return null;
            }
            if (existingList.length > 1) {
                throw new TooManyEntriesException(contextId, messageId, existingList.length);
            }
            return AoBasedNotificationService.loadFrom(existingList[0]);
        });
    }

    @Override
    public List<Notification> getAll() {
        return (List)this.ao.executeInTransaction(() -> {
            AoNotification[] existingList;
            ArrayList<Notification> ret = new ArrayList<Notification>();
            for (AoNotification current : existingList = (AoNotification[])this.ao.find(AoNotification.class)) {
                ret.add(AoBasedNotificationService.loadFrom(current));
            }
            return ret;
        });
    }

    @Override
    public List<Notification> getAll(String contextId) {
        return (List)this.ao.executeInTransaction(() -> {
            AoNotification[] existingList;
            ArrayList<Notification> ret = new ArrayList<Notification>();
            for (AoNotification current : existingList = (AoNotification[])this.ao.find(AoNotification.class, Query.select().where("CONTEXT_ID = ?", new Object[]{contextId}))) {
                ret.add(AoBasedNotificationService.loadFrom(current));
            }
            return ret;
        });
    }

    @Override
    public void ack(String contextId, @Nonnull String messageId) {
        this.ao.executeInTransaction(() -> this.ao.deleteWithSQL(AoNotification.class, QUERY_STRING_FOR_UNIQUE, new Object[]{contextId, messageId}));
    }

    private static Notification loadFrom(AoNotification aoNotification) {
        return new NotificationImpl(aoNotification.getData(), Notification.Level.valueOf(aoNotification.getLevel()), aoNotification.getMessageId(), aoNotification.getContextId());
    }

    private static class TooManyEntriesException
    extends RuntimeException {
        public TooManyEntriesException(String contextId, String messageId, int count) {
            super("There are " + count + " entries for context-id " + contextId + " and messageId " + messageId);
        }
    }
}

