/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.commons.util.PasswordUtil;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.CleanupFunction;
import java.util.Collection;
import java.util.Collections;

public class UserCleanup {
    protected final CleanupBehaviour behaviour;
    protected final AtlasUserAdapter atlasUserAdapter;
    protected final Collection<String> knownAttributes;
    private final boolean removeAllGroupAssignmentsOnCleanup;

    public UserCleanup(CleanupBehaviour behaviour, AtlasUserAdapter atlasUserAdapter, Collection<String> knownAttributes, boolean removeAllGroupAssignmentsOnCleanup) {
        this.behaviour = behaviour;
        this.atlasUserAdapter = atlasUserAdapter;
        this.knownAttributes = knownAttributes;
        this.removeAllGroupAssignmentsOnCleanup = removeAllGroupAssignmentsOnCleanup;
    }

    protected AtlasUserResult cleanupUser(AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, long timestamp) {
        AtlasUserResult resultToReturn;
        switch (this.behaviour) {
            case DELETE: {
                resultToReturn = this.atlasUserAdapter.delete(atlasUser.getReference());
                break;
            }
            case DISABLE: {
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    resultToReturn = this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_GROUPS", Collections.emptyList()).build(), timestamp, null);
                    break;
                }
                if (atlasUser.isActive()) {
                    resultToReturn = this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).build(), timestamp, null);
                    break;
                }
                resultToReturn = resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
                break;
            }
            case ANONYMIZE_REVERSIBLE: {
                if (!atlasUser.get("ATTR_IS_ANONYMIZED").isPresent()) {
                    String randomString;
                    while (this.userWithUsernameExistsInAnyDirectory(randomString = "user-" + PasswordUtil.generateSecureRandomToken(5, 0, 5))) {
                    }
                    AtlasUserBuilder builder = AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_NAME", randomString).with("ATTR_EMAIL", randomString + "@anon.user").with("ATTR_FULLNAME", randomString).with("ATTR_IS_ANONYMIZED", true);
                    if (this.removeAllGroupAssignmentsOnCleanup) {
                        builder.with("ATTR_GROUPS", Collections.emptyList());
                    }
                    resultToReturn = this.atlasUserAdapter.update(builder.build(), this.knownAttributes);
                    break;
                }
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    resultToReturn = this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(false).with("ATTR_GROUPS", Collections.emptyList()).build(), this.knownAttributes);
                    break;
                }
                resultToReturn = resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
                break;
            }
            case NONE: {
                if (this.removeAllGroupAssignmentsOnCleanup) {
                    resultToReturn = this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(atlasUser.isActive()).with("ATTR_GROUPS", Collections.emptyList()).build(), this.knownAttributes);
                    break;
                }
                resultToReturn = resultBuilder.operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
                break;
            }
            default: {
                throw new CleanupFunction.UnexpectedBehaviourException(this.behaviour);
            }
        }
        return resultToReturn;
    }

    private boolean userWithUsernameExistsInAnyDirectory(String username) {
        AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create("ATTR_NAME", username, -3L), this.knownAttributes);
        return readResult.isSuccess();
    }

    public AtlasUserResult cleanupUser(AtlasUser atlasUser) {
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(atlasUser.getReference()).initialUser(atlasUser);
        return this.cleanupUser(atlasUser, resultBuilder, System.currentTimeMillis());
    }

    protected boolean userIsAlreadyCleanedUp(AtlasUser atlasUser) {
        switch (this.behaviour) {
            case DISABLE: {
                return !atlasUser.isActive();
            }
            case ANONYMIZE_REVERSIBLE: {
                return !this.removeAllGroupAssignmentsOnCleanup && atlasUser.get("ATTR_IS_ANONYMIZED").isPresent();
            }
            case NONE: {
                return !this.removeAllGroupAssignmentsOnCleanup;
            }
        }
        return false;
    }
}

