/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.analytics;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import de.resolution.reconfigure.analytics.ConfigAnalyticsPayload;
import de.resolution.reconfigure.api.AnalyticsProvider;
import de.resolution.reconfigure.api.AnalyticsSender;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AnalyticsHeartbeatJobRunner
implements JobRunner {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsHeartbeatJobRunner.class);
    private final JobRunnerKey jobRunnerKey;
    private final SchedulerService schedulerService;
    private final AnalyticsProvider analyticsProvider;
    private final AnalyticsSender analyticsSender;

    @Inject
    public AnalyticsHeartbeatJobRunner(@ComponentImport SchedulerService schedulerService, AnalyticsProvider analyticsProvider, AnalyticsSender analyticsSender) {
        this.schedulerService = schedulerService;
        this.analyticsProvider = analyticsProvider;
        this.analyticsSender = analyticsSender;
        this.jobRunnerKey = JobRunnerKey.of((String)analyticsProvider.getSchedulerKey());
        schedulerService.registerJobRunner(this.jobRunnerKey, (JobRunner)this);
        logger.debug("Created and registered AnalyticsHeartbeatJobRunner for {}", (Object)analyticsProvider.getPluginKey());
    }

    @PreDestroy
    public void onStop() {
        logger.debug("Unregistering JobRunner {}", (Object)this.jobRunnerKey);
        this.schedulerService.unregisterJobRunner(this.jobRunnerKey);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Optional<ConfigAnalyticsPayload> analyticsPayload;
        String pluginKey = this.analyticsProvider.getPluginKey();
        logger.debug("Starting analytics heartbeat task for {}", (Object)pluginKey);
        try {
            analyticsPayload = this.analyticsProvider.getAnalyticsPayload(null);
        }
        catch (ConfigurationLoadFailedException e) {
            logger.debug("Error accessing config for analytics heartbeat", (Throwable)e);
            return JobRunnerResponse.failed((String)("Error accessing config for analytics heartbeat: " + e.getMessage()));
        }
        if (!analyticsPayload.isPresent()) {
            logger.debug("Analytics are opted out of for {}", (Object)pluginKey);
            return JobRunnerResponse.success();
        }
        this.analyticsSender.sendHeartbeat(analyticsPayload.get());
        logger.debug("Analytics task for {} is done.", (Object)pluginKey);
        return JobRunnerResponse.success();
    }
}

