/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.validate.api;

import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.impl.ValidationResultImpl;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ValidationResult {
    public static ValidationResult create() {
        return new ValidationResultImpl();
    }

    public static ValidationResult create(@Nullable ValidationMessage errorMsg, @Nullable ValidationMessage warnMsg) {
        return new ValidationResultImpl(errorMsg, warnMsg);
    }

    public ValidationResult add(ValidationResult var1);

    public ValidationResult add(int var1, ValidationResult var2);

    public ValidationResult add(String var1, ValidationResult var2);

    public ValidationResult add(String var1, @Nullable ValidationMessage var2, @Nullable ValidationMessage var3);

    public ValidationResult add(int var1, @Nullable ValidationMessage var2, @Nullable ValidationMessage var3);

    default public ValidationResult add(@Nonnull String key, @Nullable String errorMessage, @Nullable String warnMessage) {
        ValidationMessage errorValidationMessage = errorMessage == null ? null : ValidationMessage.create(errorMessage);
        ValidationMessage warnValidationMessage = warnMessage == null ? null : ValidationMessage.create(warnMessage);
        return this.add(key, errorValidationMessage, warnValidationMessage);
    }

    default public ValidationResult add(String key, @Nonnull String errorMessage) {
        return this.add(key, ValidationMessage.create(errorMessage), null);
    }

    default public ValidationResult add(int index, @Nullable String errorMessage, @Nullable String warnMessage) {
        if (errorMessage == null && warnMessage == null) {
            throw new IllegalArgumentException("Either erroMessage or warnMessage must not be null");
        }
        ValidationMessage warnValidationMessage = warnMessage == null ? null : ValidationMessage.create(warnMessage);
        ValidationMessage errorValidationMessage = errorMessage == null ? null : ValidationMessage.create(errorMessage);
        return this.add(index, errorValidationMessage, warnValidationMessage);
    }

    default public ValidationResult add(int index, String errorMessage) {
        return this.add(index, ValidationMessage.create(errorMessage), null);
    }

    public ValidationResult addError(ValidationMessage var1);

    default public ValidationResult addError(String errorMessage) {
        return this.addError(ValidationMessage.create(errorMessage));
    }

    public ValidationResult addWarning(ValidationMessage var1);

    default public ValidationResult addWarning(String warningMessage) {
        return this.addWarning(ValidationMessage.create(warningMessage));
    }

    @Nonnull
    public List<ValidationMessage> getErrors();

    @Nonnull
    public List<ValidationMessage> getWarnings();

    @Nonnull
    public Map<String, ValidationResult> getMap();

    @Nonnull
    public List<ValidationResult> getList();

    public boolean isValid();

    public boolean isContainsWarnings();

    public String asJson();
}

