/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.cert.impl;

import de.resolution.commons.cert.api.CertificateCheckResult;
import de.resolution.commons.cert.impl.SimpleCertificateCheckResultImpl;
import java.security.cert.X509Certificate;

public class CertificateCheckResultBuilder {
    private boolean valid = false;
    private boolean expired = false;
    private String message = "";
    private boolean privateKey = false;
    private X509Certificate certificate;

    public CertificateCheckResultBuilder valid() {
        this.valid = true;
        return this;
    }

    public CertificateCheckResultBuilder privateKey() {
        this.privateKey = true;
        return this;
    }

    public CertificateCheckResultBuilder noPrivateKey() {
        this.privateKey = false;
        return this;
    }

    public CertificateCheckResultBuilder inValid() {
        this.valid = false;
        return this;
    }

    public CertificateCheckResultBuilder expired(boolean expired) {
        this.expired = expired;
        return this;
    }

    public CertificateCheckResultBuilder message(String message) {
        this.message = message;
        return this;
    }

    public CertificateCheckResultBuilder certificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public CertificateCheckResult build() {
        return new SimpleCertificateCheckResultImpl(this.certificate, this.valid, this.expired, this.privateKey, this.message);
    }
}

