/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.oauth;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.impl.oauth.AbstractOAuthServlet;
import de.resolution.usersync.spi.OAuthConnector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResetOauthServlet
extends AbstractOAuthServlet {
    private static final Logger logger = LoggerFactory.getLogger(ResetOauthServlet.class);
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;

    @Autowired
    public ResetOauthServlet(PrivilegeChecker privilegeChecker, ConnectorService connectorService, @ComponentImport TemplateRenderer templateRenderer) {
        super(templateRenderer, "/resetOauthAuthorization.vm");
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        try {
            this.privilegeChecker.checkSysAdmin(req);
        }
        catch (InsufficientUserPrivilegeException e) {
            this.renderErrorPage(403, "You don't have the required privileges to do this operation.", resp);
        }
        String connectorId = req.getParameter("connectorId");
        if (connectorId == null) {
            this.renderErrorPage(400, "connectorId is missing", resp);
            return;
        }
        try {
            Object loadedConnector = this.connectorService.getConnectorByUniqueId(connectorId).getConnector();
            if (!(loadedConnector instanceof OAuthConnector)) {
                this.renderErrorPage(400, "Connector is no OAuthConnector", resp);
            } else {
                OAuthConnector connector = (OAuthConnector)loadedConnector;
                connector.resetAuthorization();
                this.renderPage(200, true, "Authorization was successfully reset. Please close this window and reload the connector page.", resp);
            }
        }
        catch (ConnectorNotFoundException e) {
            this.renderErrorPage(400, "Connector was not found", resp);
        }
        catch (ConnectorFactoryNotAvailableException e) {
            logger.warn("Connector Factory is not available", (Throwable)e);
            this.renderErrorPage(500, "Connector Factory not available", resp);
        }
        catch (ConfigurationFailedException e) {
            logger.warn("Connector Configuration failed", (Throwable)e);
            this.renderErrorPage(500, "Connector Configuration failed", resp);
        }
    }
}

