/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.api.UserSyncService;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="syncJobRunner")
public class SyncJobRunner
implements JobRunner {
    private static final Logger logger = LoggerFactory.getLogger(SyncJobRunner.class);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)SyncJobRunner.class.getCanonicalName());
    private final UserSyncService userSyncService;
    private final SyncStatusRepository syncStatusRepository;

    @Inject
    public SyncJobRunner(UserSyncService userSyncService, SyncStatusRepository syncStatusRepository, @ComponentImport SchedulerService schedulerService) {
        this.userSyncService = userSyncService;
        this.syncStatusRepository = syncStatusRepository;
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        int syncStatusId;
        Map parameterMap = jobRunnerRequest.getJobConfig().getParameters();
        Serializable connectorIdSerializable = (Serializable)parameterMap.get("CONNECTOR_UID");
        if (connectorIdSerializable == null) {
            return JobRunnerResponse.failed((String)"No Connector-UID found");
        }
        if (!(connectorIdSerializable instanceof String)) {
            return JobRunnerResponse.failed((String)("Connector-UID " + connectorIdSerializable + " is no String"));
        }
        String connectorUID = (String)((Object)connectorIdSerializable);
        Serializable syncStatusIdSerializable = (Serializable)parameterMap.get("SYNCSTATUS_ID");
        if (syncStatusIdSerializable == null) {
            syncStatusId = this.syncStatusRepository.create(connectorUID).getId();
        } else {
            if (!(syncStatusIdSerializable instanceof Integer)) {
                return JobRunnerResponse.failed((String)("SyncStatus-ID " + connectorIdSerializable + " is no Integer"));
            }
            syncStatusId = (Integer)syncStatusIdSerializable;
        }
        try {
            this.userSyncService.sync(connectorUID, syncStatusId);
        }
        catch (Exception e) {
            logger.warn("Starting scheduled UserSync failed", (Throwable)e);
            return JobRunnerResponse.failed((String)("Sync failed: " + e.getMessage()));
        }
        return JobRunnerResponse.success();
    }
}

