/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupAdapter;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.api.group.GroupSearchResult;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.AttributeFilter;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.atlasuser.impl.group.AtlasGroupBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.SearchFilterBuilder;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.api.cleanup.UserCleanup;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.builtin.scim.exception.GroupNotFoundException;
import de.resolution.usersync.builtin.scim.exception.UserNotFoundException;
import de.resolution.usersync.builtin.scim.group.ScimCoreGroup;
import de.resolution.usersync.builtin.scim.user.ScimCoreUser;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class ScimConnector
extends AbstractConnector<ScimConnectorConfiguration> {
    public static final String ATTRIBUTE_SCIM_EXTERNAL_ID = "SCIM_EXTERNAL_ID";
    protected static final String VALUE = "value";
    private static final Logger logger = LoggerFactory.getLogger(ScimConnector.class);
    private final AtlasGroupAdapter atlasGroupAdapter;

    protected ScimConnector(@Nonnull ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, AtlasGroupAdapter atlasGroupAdapter, @Nonnull ScimConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/ScimConnector.json");
        this.atlasGroupAdapter = atlasGroupAdapter;
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.fail("Sync is not supported in this connector", logger);
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.failed("Single User Update is not supported in this connector");
    }

    @Override
    @Nullable
    public String getAuthorizationCodeUrl() {
        return this.getScimBaseUrl();
    }

    @Nonnull
    public String getScimBaseUrl() {
        return String.format("%s%s/usersync/connector/%s/scim/v2", this.connectorService.getBaseUrl(), "/rest/samlsso-admin/1.0", this.getUniqueId());
    }

    @Override
    @Nonnull
    public Class<ScimConnectorConfiguration> getConfigurationClass() {
        return ScimConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "SCIM 2.0";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return ScimCoreUser.getFlatAttributes();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanSync() {
        return false;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isCanBeScheduled() {
        return false;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return true;
    }

    @Override
    public boolean isSelectableDirectory() {
        return false;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return false;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Nonnull
    public AtlasUser buildAtlasUser(@Nullable String userId, @Nonnull StructuredData data) throws ScimException {
        AtlasUserReference ref;
        TransformationResults transformationResults;
        try {
            transformationResults = this.applyTransformations(data.asMap(), null, null);
        }
        catch (TransformationFailedException e) {
            throw new ServerErrorException("Could not create AtlasUser because of failing transformation: " + e.getMessage(), null, e);
        }
        HashMap<String, Collection<String>> transformedAttributes = new HashMap<String, Collection<String>>(transformationResults.getTransformedAttributes());
        if (userId != null && !userId.isEmpty()) {
            ref = AtlasUserReference.create("ATTR_ID", userId, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        } else {
            AttributeTransformationResult lookupAttributeTransformationResult;
            String findByAttributeName = ((ScimConnectorConfiguration)this.configuration).getFindByAttributeName();
            try {
                lookupAttributeTransformationResult = this.transformLookupAttribute(data.asMap(), null, findByAttributeName);
            }
            catch (TransformationFailedException e) {
                throw new BadRequestException("Transformation for lookup attribute failed.", "invalidValue");
            }
            String findByAttributeValue = lookupAttributeTransformationResult.getFirstValue();
            if (findByAttributeValue == null || findByAttributeValue.isEmpty()) {
                throw new BadRequestException("Transformation for " + findByAttributeName + " returned no value", "invalidValue");
            }
            if (lookupAttributeTransformationResult.isDrop()) {
                throw new BadRequestException("Lookup attribute must not be dropped during transformation", "invalidValue");
            }
            if (lookupAttributeTransformationResult.isDropAll()) {
                throw new BadRequestException("Lookup attribute transformation returned dropAll", "invalidValue");
            }
            ref = AtlasUserReference.create(findByAttributeName, findByAttributeValue, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        }
        AtlasUserBuilder atlasUserBuilder = AtlasUser.builder();
        atlasUserBuilder.findBy(ref).in(((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        transformedAttributes.forEach(atlasUserBuilder::with);
        atlasUserBuilder.with("ATTR_IS_ANONYMIZED", Collections.emptySet());
        return atlasUserBuilder.build();
    }

    @Nonnull
    private AtlasGroup buildAtlasGroup(@Nullable String groupname, @Nonnull StructuredData data) {
        if (groupname == null) {
            groupname = data.findOrEmpty("displayName").asString();
        }
        AtlasGroupReference ref = AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasGroupBuilder atlasGroupBuilder = AtlasGroup.builder();
        atlasGroupBuilder.findBy(ref).with("ATTR_GROUPNAME", groupname).with(ATTRIBUTE_SCIM_EXTERNAL_ID, data.findString("externalId"));
        ArrayList<String> memberIds = new ArrayList<String>();
        StructuredData members = data.find("members");
        if (members != null && members.isList()) {
            for (StructuredData member : members.asList()) {
                String memberId = member.findString(VALUE);
                if (memberId != null) {
                    memberIds.add(memberId);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("SCIM group does not contain a member value: {}", (Object)JSONUtil.asJson(member));
            }
            atlasGroupBuilder.with("ATTR_MEMBERS", memberIds);
        }
        return atlasGroupBuilder.build();
    }

    @Nonnull
    public ScimCoreUser buildScimUser(@Nonnull AtlasUser atlasUser, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        ScimCoreUser.ScimCoreUserBuilder builder = ScimCoreUser.builder().with("id", atlasUser.get("ATTR_ID").orElse(null)).with("userName", atlasUser.get("ATTR_NAME").orElse(null)).with("externalId", atlasUser.get(ATTRIBUTE_SCIM_EXTERNAL_ID).orElse(null)).with("displayName", atlasUser.get("ATTR_FULLNAME").orElse(null)).with("name.formatted", atlasUser.get("ATTR_FULLNAME").orElse(null)).active(atlasUser.isActive()).with("emails[0].value", atlasUser.get("ATTR_EMAIL").orElse(null)).with("emails[0].type", "work");
        ArrayList groups2 = new ArrayList();
        if (atlasUser.get("ATTR_GROUPS").isPresent()) {
            Set<String> groupnames = atlasUser.getAttributeValues("ATTR_GROUPS");
            for (String groupname : groupnames) {
                HashMap<String, String> group = new HashMap<String, String>();
                group.put(VALUE, groupname);
                group.put("display", groupname);
                group.put("#ref", this.createGroupRef(groupname));
                groups2.add(group);
            }
        }
        builder.with("groups", groups2);
        excludedAttributes.forEach(builder::without);
        return builder.build();
    }

    @Nonnull
    public ScimCoreGroup buildScimGroup(@Nonnull AtlasGroup group, @Nullable List<String> memberIds, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        ScimCoreGroup.ScimCoreGroupBuilder builder = ScimCoreGroup.builder();
        builder.with("id", group.getGroupName());
        builder.with("displayName", group.getGroupName());
        group.get(ATTRIBUTE_SCIM_EXTERNAL_ID).ifPresent(externalId -> builder.with("externalId", externalId));
        if (memberIds != null) {
            ArrayList members = new ArrayList();
            for (String userId : memberIds) {
                HashMap<String, String> member = new HashMap<String, String>();
                member.put(VALUE, userId);
                member.put("type", "User");
                member.put("#ref", this.createUserRef(userId));
                members.add(member);
            }
            builder.with("members", members);
        }
        excludedAttributes.forEach(builder::without);
        return builder.build();
    }

    @Nonnull
    String createUserRef(@Nonnull String id) {
        return this.getScimBaseUrl() + "/Users/" + id;
    }

    @Nonnull
    String createGroupRef(@Nonnull String id) {
        return this.getScimBaseUrl() + "/Groups/" + id;
    }

    @Nullable
    public String getUserIdForUserWithExternalId(@Nonnull String attributeName, @Nonnull String attributeValue) {
        AtlasUserReference ref = AtlasUserReference.create(attributeName, attributeValue, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult foundUserResult = this.atlasUserAdapter.readFirstUniqueUser(ref, this.attributeTransformerMap.keySet());
        Optional<AtlasUser> optionalResultingUser = foundUserResult.getResultingUser();
        if (!optionalResultingUser.isPresent()) {
            return null;
        }
        AtlasUser resultingUser = optionalResultingUser.get();
        Optional<String> optionalId = resultingUser.get("ATTR_ID");
        return optionalId.orElse(null);
    }

    @Nonnull
    public List<ScimCoreUser> getUsers(int startIndex, int count, @Nullable Filter filter, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        UserSearchResult searchResult;
        if (filter != null) {
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "userName".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String username = filter.getComparisonValue().textValue();
                String userid = this.getUserIdForUserWithExternalId("ATTR_NAME", username);
                if (userid == null) {
                    return Collections.emptyList();
                }
                try {
                    return Collections.singletonList(this.getUser(userid, attributes, excludedAttributes));
                }
                catch (ResourceNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    return Collections.emptyList();
                }
            }
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "externalId".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String externalId = filter.getComparisonValue().textValue();
                String userid = this.getUserIdForUserWithExternalId(ATTRIBUTE_SCIM_EXTERNAL_ID, externalId);
                if (userid == null) {
                    return Collections.emptyList();
                }
                try {
                    return Collections.singletonList(this.getUser(userid, attributes, excludedAttributes));
                }
                catch (ResourceNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    return Collections.emptyList();
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("Unsupported user filter: {}", (Object)JSONUtil.asJson(filter));
            }
            throw new BadRequestException("Unsupported filter", "invalidFilter");
        }
        SearchFilterBuilder searchFilterBuilder = SearchFilter.builder().directoryId(((ScimConnectorConfiguration)this.configuration).getDirectoryId()).attributeFilters(AttributeFilter.notPresent("ATTR_IS_ANONYMIZED"));
        try {
            searchResult = this.atlasUserAdapter.search(searchFilterBuilder.build(), SortBy.name(), new SimpleCancelHandle());
        }
        catch (AtlasUserOperationFailedException | DirectoryNotFoundException | InvalidSearchFilterException e) {
            throw new ServerErrorException(e.getMessage(), null, e);
        }
        ArrayList<ScimCoreUser> users = new ArrayList<ScimCoreUser>();
        if (count > 0) {
            List<Optional<AtlasUser>> atlasUsers;
            try {
                atlasUsers = searchResult.retrievePage(startIndex, count);
            }
            catch (AtlasUserOperationFailedException e) {
                throw new ServerErrorException(e.getMessage(), null, e);
            }
            for (Optional<AtlasUser> optionalAtlasUser : atlasUsers) {
                if (optionalAtlasUser.isPresent()) {
                    users.add(this.buildScimUser(optionalAtlasUser.get(), attributes, excludedAttributes));
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("Resulting User not present during while loading users");
            }
        } else {
            for (Optional optionalAtlasUser : searchResult) {
                if (optionalAtlasUser.isPresent()) {
                    users.add(this.buildScimUser((AtlasUser)optionalAtlasUser.get(), attributes, excludedAttributes));
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("Resulting User not present during while loading users");
            }
        }
        return users;
    }

    @Nonnull
    public ScimCoreUser getUser(@Nonnull String userId, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUserReference userRef = AtlasUserReference.create("ATTR_ID", userId, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(userRef, this.attributeTransformerMap.keySet());
        Optional<AtlasUser> optionalResultingUser = readResult.getResultingUser();
        if (readResult.isSuccess() && optionalResultingUser.isPresent()) {
            AtlasUser resultingUser = optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Get user failed: {}", (Object)JSONUtil.asJson(readResult));
        }
        throw new UserNotFoundException(userId);
    }

    @Nonnull
    public ScimCoreUser createOrUpdateUser(@Nonnull StructuredData data, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUser atlasUserToCreate = this.buildAtlasUser(null, data);
        AtlasUserResult createOrUpdateResult = this.atlasUserAdapter.createOrUpdate(atlasUserToCreate, ((ScimConnectorConfiguration)this.configuration).getCopyBehaviour(), this.attributeTransformerMap.keySet());
        Optional<AtlasUser> optionalResultingUser = createOrUpdateResult.getResultingUser();
        if (createOrUpdateResult.isSuccess() && optionalResultingUser.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} user: {}", (Object)createOrUpdateResult.getOperation(), (Object)JSONUtil.asJson(createOrUpdateResult));
            }
            AtlasUser resultingUser = optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isErrorEnabled()) {
            logger.error("Creating or updating user failed: {}", (Object)JSONUtil.asJson(createOrUpdateResult));
        }
        throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)createOrUpdateResult.getMessages().orElse(Collections.singletonList("Creating user failed"))));
    }

    @Nonnull
    public ScimCoreUser updateUser(String userId, StructuredData data, Set<String> attributes, Set<String> excludedAttributes) throws ScimException {
        AtlasUser atlasUserToUpdate = this.buildAtlasUser(userId, data);
        AtlasUserResult updateResult = this.atlasUserAdapter.update(atlasUserToUpdate, this.attributeTransformerMap.keySet());
        Optional<AtlasUser> optionalResultingUser = updateResult.getResultingUser();
        if (updateResult.isSuccess() && optionalResultingUser.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updated user: {}", (Object)JSONUtil.asJson(updateResult));
            }
            AtlasUser resultingUser = optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isErrorEnabled()) {
            logger.error("Updating user failed: {}", (Object)JSONUtil.asJson(updateResult));
        }
        throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)updateResult.getMessages().orElse(Collections.singletonList("Updating user failed"))));
    }

    public void deleteUser(@Nonnull String userId) throws ResourceNotFoundException, ServerErrorException {
        AtlasUserReference ref = AtlasUserReference.create("ATTR_ID", userId, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(ref, this.attributeTransformerMap.keySet());
        Optional<AtlasUser> optionalAtlasUser = atlasUserResult.getResultingUser();
        if (!atlasUserResult.isSuccess() || !optionalAtlasUser.isPresent()) {
            throw new UserNotFoundException(userId);
        }
        UserCleanup userCleanup = new UserCleanup(((ScimConnectorConfiguration)this.configuration).getCleanupBehaviour(), this.atlasUserAdapter, this.attributeTransformerMap.keySet(), ((ScimConnectorConfiguration)this.configuration).isRemoveAllGroupAssignmentsOnCleanup());
        AtlasUserResult cleanupResult = userCleanup.cleanupUser(optionalAtlasUser.get());
        if (cleanupResult.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaned up user: {}", (Object)JSONUtil.asJson(cleanupResult));
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("Cleaning up user failed: {}", (Object)JSONUtil.asJson(cleanupResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)cleanupResult.getMessages().orElse(Collections.singletonList("Cleaning up user failed"))));
        }
    }

    @Nonnull
    public List<ScimCoreGroup> getDirectoryGroups(int startIndex, int count, @Nullable Filter filter, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        GroupSearchResult groupSearchResult;
        if (filter != null) {
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "displayName".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String groupname = filter.getComparisonValue().textValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("Filter by groupname {}", (Object)groupname);
                }
                try {
                    return Collections.singletonList(this.getDirectoryGroup(groupname, attributes, excludedAttributes));
                }
                catch (ResourceNotFoundException e) {
                    logger.debug(e.getMessage());
                    return Collections.emptyList();
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("Unsupported group filter: {}", (Object)JSONUtil.asJson(filter));
            }
            throw new BadRequestException("Unsupported filter", "invalidFilter");
        }
        try {
            groupSearchResult = this.atlasGroupAdapter.search(startIndex, count, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        }
        catch (AtlasUserOperationFailedException e) {
            throw new ServerErrorException(e.getMessage(), null, e);
        }
        ArrayList<ScimCoreGroup> groups2 = new ArrayList<ScimCoreGroup>();
        for (AtlasGroup group : groupSearchResult.getGroups()) {
            List<String> memberIds = this.getGroupMembers(group.getReference().getGroupName());
            groups2.add(this.buildScimGroup(group, memberIds, attributes, excludedAttributes));
        }
        return groups2;
    }

    @Nonnull
    public ScimCoreGroup getDirectoryGroup(@Nonnull String groupname, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasGroupResult readResult = this.atlasGroupAdapter.read(AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
        Optional<AtlasGroup> optionalResultingGroup = readResult.getResultingGroup();
        if (readResult.isSuccess() && optionalResultingGroup.isPresent()) {
            AtlasGroup group = optionalResultingGroup.get();
            List<String> memberIds = this.getGroupMembers(group.getReference().getGroupName());
            return this.buildScimGroup(group, memberIds, attributes, excludedAttributes);
        }
        if (logger.isDebugEnabled()) {
            logger.error("Group not found: {}", (Object)JSONUtil.asJson(readResult));
        }
        throw new GroupNotFoundException(groupname);
    }

    @Nonnull
    public ScimCoreGroup createDirectoryGroup(@Nonnull StructuredData data, Set<String> attributes, Set<String> excludedAttributes) throws ScimException {
        AtlasGroup createdGroup;
        String groupName;
        AtlasGroup atlasGroupToCreate = this.buildAtlasGroup(null, data);
        AtlasGroupResult findByGroupnameResult = this.atlasGroupAdapter.read(atlasGroupToCreate.getReference());
        if (findByGroupnameResult.isSuccess() && findByGroupnameResult.getResultingGroup().isPresent()) {
            throw new ResourceConflictException("Group with name " + atlasGroupToCreate.getGroupName() + " already exists", "uniqueness", null);
        }
        AtlasGroupResult createResult = this.atlasGroupAdapter.create(atlasGroupToCreate);
        Optional<AtlasGroup> optionalResultingGroup = createResult.getResultingGroup();
        if (!createResult.isSuccess() || !optionalResultingGroup.isPresent()) {
            if (logger.isErrorEnabled()) {
                logger.error("Creating group failed: {}", (Object)JSONUtil.asJson(createResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)createResult.getMessages().orElse(Collections.singletonList("Creating group failed"))));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created group: {}", (Object)JSONUtil.asJson(createResult));
        }
        if ((groupName = (createdGroup = optionalResultingGroup.get()).getGroupName()) == null) {
            throw new ServerErrorException("Group contains no groupname after creation");
        }
        this.setGroupMembers(groupName, atlasGroupToCreate.getAttributeValues("ATTR_MEMBERS"));
        return this.getDirectoryGroup(createdGroup.getGroupName(), attributes, excludedAttributes);
    }

    @Nonnull
    public ScimCoreGroup updateDirectoryGroup(String groupname, StructuredData data, Set<String> attributes, Set<String> excludedAttributes) throws ScimException {
        AtlasGroup atlasGroupToUpdate = this.buildAtlasGroup(groupname, data);
        this.setGroupMembers(groupname, atlasGroupToUpdate.getAttributeValues("ATTR_MEMBERS"));
        return this.getDirectoryGroup(groupname, attributes, excludedAttributes);
    }

    public void deleteDirectoryGroup(@Nonnull String groupname) throws ScimException {
        AtlasGroupReference ref = AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasGroupResult deleteResult = this.atlasGroupAdapter.delete(ref);
        if (deleteResult.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleted group: {}", (Object)JSONUtil.asJson(deleteResult));
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("Deleting group failed: {}", (Object)JSONUtil.asJson(deleteResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)deleteResult.getMessages().orElse(Collections.singletonList("Deleting group failed"))));
        }
    }

    @Nonnull
    public List<String> getGroupMembers(@Nonnull String groupname) throws ScimException {
        ArrayList<String> members = new ArrayList<String>();
        try {
            UserSearchResult directMemberships = this.atlasGroupAdapter.getDirectMemberships(AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            Iterator<Map<String, String>> userWithAttributesIterator = directMemberships.coreAttributesIterator();
            while (userWithAttributesIterator.hasNext()) {
                Map<String, String> coreAttributes = userWithAttributesIterator.next();
                String id = coreAttributes.get("ATTR_ID");
                if (StringUtil.isNullOrEmpty(id)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("User has no externalId: {}", (Object)JSONUtil.asJson(coreAttributes));
                    continue;
                }
                members.add(id);
            }
        }
        catch (AtlasUserOperationFailedException | DirectoryNotFoundException | InvalidSearchFilterException e) {
            throw new ServerErrorException(e.getMessage(), null, e);
        }
        return members;
    }

    public void setGroupMembers(@Nonnull String groupname, @Nullable Set<String> memberIds) throws ScimException {
        List<String> currentMemberIds = this.getGroupMembers(groupname);
        if (logger.isTraceEnabled()) {
            logger.trace("Current memberIds: {}", (Object)JSONUtil.asJson(currentMemberIds));
        }
        if (memberIds == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("List of memberIds is empty, no members to assign");
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Submitted memberIds: {}", (Object)JSONUtil.asJson(memberIds));
        }
        ArrayList<String> userIdsToAssign = new ArrayList<String>(memberIds);
        ArrayList<String> userIdsToUnassign = new ArrayList<String>();
        for (String currentMemberId : currentMemberIds) {
            if (!memberIds.contains(currentMemberId)) {
                userIdsToUnassign.add(currentMemberId);
                continue;
            }
            userIdsToAssign.remove(currentMemberId);
        }
        this.unassignDirectoryGroups(groupname, userIdsToUnassign);
        this.assignDirectoryGroups(groupname, userIdsToAssign);
    }

    public void assignDirectoryGroups(@Nonnull String groupname, @Nonnull List<String> membersToAdd) throws ServerErrorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Assign userIds {} to group {}", (Object)JSONUtil.asJson(membersToAdd), (Object)StringUtil.sanitize(groupname));
        }
        for (String userIdToAssign : membersToAdd) {
            AtlasGroupResult assignResult = this.atlasGroupAdapter.addUserToGroup(AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasUserReference.create("ATTR_ID", userIdToAssign, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (assignResult.isSuccess()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Added user with id {} to group {}: {}", new Object[]{JSONUtil.asJson(membersToAdd), StringUtil.sanitize(groupname), JSONUtil.asJson(assignResult)});
                continue;
            }
            if (logger.isErrorEnabled()) {
                logger.error("Adding user with id {} to group {} failed: {}", new Object[]{JSONUtil.asJson(membersToAdd), StringUtil.sanitize(groupname), JSONUtil.asJson(assignResult)});
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)assignResult.getMessages().orElse(Collections.singletonList("Assigning users failed"))));
        }
    }

    public void unassignDirectoryGroups(@Nonnull String groupname, @Nonnull List<String> membersToRemove) throws ServerErrorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Unassign userIds {} from group {}", (Object)JSONUtil.asJson(membersToRemove), (Object)StringUtil.sanitize(groupname));
        }
        for (String userId : membersToRemove) {
            AtlasGroupResult unassignResult = this.atlasGroupAdapter.removeUserFromGroup(AtlasGroupReference.create(groupname, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasUserReference.create("ATTR_ID", userId, ((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (unassignResult.isSuccess()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Removed user with id {} from group {}: {}", new Object[]{JSONUtil.asJson(membersToRemove), StringUtil.sanitize(groupname), JSONUtil.asJson(unassignResult)});
                continue;
            }
            if (logger.isErrorEnabled()) {
                logger.error("Removing user with id {} from group {} failed: {}", new Object[]{JSONUtil.asJson(membersToRemove), StringUtil.sanitize(groupname), JSONUtil.asJson(unassignResult)});
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)unassignResult.getMessages().orElse(Collections.singletonList("Unassigning users failed"))));
        }
    }
}

