/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.TransformationResults;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"status", "transformationResults", "updateUserResult"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncSingleUserResult {
    private final AtlasUserResult updateUserResult;
    private final String errorMessage;
    private final TransformationResults transformationResults;
    private final Status status;
    private final Map<String, ?> userAttributes;
    private final ExceptionInfo exceptionInfo;

    public static SyncSingleUserResult createFound(Map<String, List<String>> userAttributes, TransformationResults transformationResults, AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.FOUND, userAttributes, transformationResults, updateUserResult, null, null);
    }

    public static SyncSingleUserResult createFound(AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.FOUND, null, null, updateUserResult, null, null);
    }

    public static SyncSingleUserResult createFiltered(Map<String, List<String>> userAttributes, TransformationResults transformationResults) {
        return new SyncSingleUserResult(Status.FILTERED, userAttributes, transformationResults, null, null, null);
    }

    public static SyncSingleUserResult createFiltered(Map<String, List<String>> userAttributes, AtlasUserResult atlasUserResult, TransformationResults transformationResults) {
        return new SyncSingleUserResult(Status.FILTERED, userAttributes, transformationResults, atlasUserResult, null, null);
    }

    public static SyncSingleUserResult createPreFiltered(Map<String, ?> userAttributes) {
        return new SyncSingleUserResult(Status.PREFILTERED, userAttributes, null, null, null, null);
    }

    public static SyncSingleUserResult createPreFiltered(Map<String, ?> userAttributes, AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.PREFILTERED, userAttributes, null, updateUserResult, null, null);
    }

    public static SyncSingleUserResult createNotUnique() {
        return new SyncSingleUserResult(Status.NOT_UNIQUE, null, null, null, null, null);
    }

    public static SyncSingleUserResult createNotFound() {
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, null, null);
    }

    public static SyncSingleUserResult createNotFound(@Nullable AtlasUserResult disableResult) {
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, disableResult, null, null);
    }

    public static SyncSingleUserResult createNotFound(@Nullable String errorMessage, @Nullable Exception exception) {
        if (exception != null) {
            return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, errorMessage, ExceptionInfo.from(exception));
        }
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, errorMessage, null);
    }

    public static SyncSingleUserResult createOther(String message) {
        return new SyncSingleUserResult(Status.OTHER, null, null, null, message, null);
    }

    public static SyncSingleUserResult createFailure(@Nonnull String errorMessage) {
        return new SyncSingleUserResult(Status.FAILED, null, null, null, errorMessage, null);
    }

    public static SyncSingleUserResult createFailure(@Nullable Exception e) {
        if (e == null) {
            return new SyncSingleUserResult(Status.FAILED, null, null, null, "Undefined error", null);
        }
        return new SyncSingleUserResult(Status.FAILED, null, null, null, e.getMessage(), SyncSingleUserResult.createExceptionInfo(e));
    }

    public static SyncSingleUserResult createFoundOrFailed(@Nonnull FindUserResult findUserResult, @Nonnull SyncUserResult syncUserResult) {
        MapStructuredData attributesFromConnector = null;
        if (findUserResult.getAttributesFromConnector().isMap()) {
            attributesFromConnector = findUserResult.getAttributesFromConnector().asMap();
        }
        TransformationResults transformationResults = syncUserResult.getTransformationResults();
        AtlasUserResult atlasUserResult = syncUserResult.getAtlasUserResult();
        Status status = Status.FAILED;
        if (atlasUserResult != null && atlasUserResult.isSuccess()) {
            status = Status.FOUND;
        }
        return new SyncSingleUserResult(status, attributesFromConnector, transformationResults, atlasUserResult, syncUserResult.getMessage(), null);
    }

    public static SyncSingleUserResult createFailure(@Nullable String messagePrefix, @Nonnull Exception e) {
        String prefix = "";
        if (messagePrefix != null) {
            prefix = messagePrefix + ": ";
        }
        String stackTraceLine = "";
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements.length > 0) {
            stackTraceLine = stackTraceElements[0].toString();
        }
        String exMessage = "";
        if (e.getMessage() != null) {
            exMessage = e.getMessage() + ": ";
        }
        return new SyncSingleUserResult(Status.FAILED, null, null, null, prefix + exMessage + e.getClass() + " at " + stackTraceLine, SyncSingleUserResult.createExceptionInfo(e));
    }

    @JsonCreator
    public SyncSingleUserResult(@Nonnull @JsonProperty(value="status") Status status, @Nullable @JsonProperty(value="userProperties") Map<String, ?> userAttributes, @Nullable @JsonProperty(value="transformationResults") TransformationResults transformationResults, @Nullable @JsonProperty(value="updateUserResult") AtlasUserResult updateUserResult, @Nullable @JsonProperty(value="errorMessage") String errorMessage, @Nullable @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo) {
        this.status = status;
        this.userAttributes = userAttributes == null ? Collections.emptyMap() : userAttributes;
        this.transformationResults = transformationResults;
        this.updateUserResult = updateUserResult;
        this.errorMessage = errorMessage;
        this.exceptionInfo = exceptionInfo;
    }

    @Nullable
    public AtlasUserResult getUpdateUserResult() {
        return this.updateUserResult;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public TransformationResults getTransformationResults() {
        return this.transformationResults;
    }

    @Nullable
    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    public Map<String, ?> getUserAttributes() {
        return this.userAttributes;
    }

    @Nullable
    private static ExceptionInfo createExceptionInfo(Exception ex) {
        if (ex != null) {
            return ExceptionInfo.from(ex);
        }
        return null;
    }

    public static enum Status {
        FOUND,
        NOT_FOUND,
        NOT_UNIQUE,
        FILTERED,
        FAILED,
        PREFILTERED,
        OTHER;

    }
}

