/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import de.resolution.commons.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JSONUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter;

    private JSONUtil() {
    }

    @Nonnull
    public static JsonNode asJsonNode(@Nonnull String jsonString) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static JsonNode asJsonNode(@Nonnull Object object) {
        return objectMapper.valueToTree(object);
    }

    @Nonnull
    public static <T> T fromJson(@Nonnull String jsonString, @Nonnull Class<T> clazz) {
        try {
            return objectMapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static <T> T fromJson(@Nonnull JsonNode jsonNode, @Nonnull Class<T> clazz) {
        try {
            return objectMapper.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static String asJson(@Nullable Object object) {
        try {
            return objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationFailedException(e);
        }
    }

    public static boolean isValidJson(@Nullable String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return false;
        }
        try {
            objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Nonnull
    public static <K, V> Map<K, V> deserializeMap(@Nullable String jsonStr) {
        if (StringUtil.isNullOrEmpty(jsonStr)) {
            return Collections.emptyMap();
        }
        TypeReference typeRef = new TypeReference<Map<K, V>>(){};
        try {
            return (Map)objectMapper.readValue(jsonStr, typeRef);
        }
        catch (JsonProcessingException e) {
            return Collections.emptyMap();
        }
    }

    @Nonnull
    public static <K> List<K> deserializeList(@Nullable String jsonStr) {
        if (StringUtil.isNullOrEmpty(jsonStr)) {
            return Collections.emptyList();
        }
        TypeReference typeRef = new TypeReference<List<K>>(){};
        try {
            return (List)objectMapper.readValue(jsonStr, typeRef);
        }
        catch (JsonProcessingException e) {
            return Collections.emptyList();
        }
    }

    public static JsonNode applyMergePatch(@Nonnull JsonNode nodeToBePatched, @Nonnull JsonNode nodeWithPatch) {
        try {
            JsonMergePatch mergePatch = JsonMergePatch.fromJson(nodeWithPatch);
            return mergePatch.apply(nodeToBePatched);
        }
        catch (JsonPatchException e) {
            throw new JsonPatchFailedException(e);
        }
    }

    public static JsonNode applyPatch(@Nonnull JsonNode nodeToBePatched, @Nonnull JsonNode nodeWithPatch) {
        try {
            JsonPatch mergePatch = JsonPatch.fromJson(nodeWithPatch);
            return mergePatch.apply(nodeToBePatched);
        }
        catch (JsonPatchException | IOException e) {
            throw new JsonPatchFailedException(e);
        }
    }

    static {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }

    public static class JsonDeserializationFailedException
    extends RuntimeException {
        public JsonDeserializationFailedException(Throwable cause) {
            super("Creating object from JSON failed", cause);
        }
    }

    public static class JsonPatchFailedException
    extends RuntimeException {
        public JsonPatchFailedException(Throwable cause) {
            super("Patching JSON failed", cause);
        }
    }

    public static class JsonSerializationFailedException
    extends RuntimeException {
        public JsonSerializationFailedException(Throwable cause) {
            super("Creating JSON failed", cause);
        }
    }
}

