/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.model.user.User;
import de.resolution.atlasuser.api.user.SortBy;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserSearchResultEntry {
    private final long directoryId;
    private final int directoryOrder;
    private final String username;
    private final String sortByAttributeValue;
    private static final Logger logger = LoggerFactory.getLogger(UserSearchResultEntry.class);

    public UserSearchResultEntry(User crowdUser, int directoryOrder, SortBy sortBy) {
        switch (sortBy.getAttributeName()) {
            case "ATTR_NAME": {
                this.sortByAttributeValue = crowdUser.getName();
                break;
            }
            case "ATTR_EMAIL": {
                this.sortByAttributeValue = crowdUser.getEmailAddress();
                break;
            }
            case "ATTR_FULLNAME": {
                this.sortByAttributeValue = crowdUser.getDisplayName();
                break;
            }
            default: {
                logger.warn("Unknown sortBy-Attribute {}, sorting by username", (Object)sortBy.getAttributeName());
                this.sortByAttributeValue = crowdUser.getName();
            }
        }
        this.directoryId = crowdUser.getDirectoryId();
        this.directoryOrder = directoryOrder;
        this.username = crowdUser.getName();
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public int getDirectoryOrder() {
        return this.directoryOrder;
    }

    public String getUsername() {
        return this.username;
    }

    String getSortByAttributeValue() {
        return this.sortByAttributeValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearchResultEntry that = (UserSearchResultEntry)o;
        return this.directoryId == that.directoryId && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.directoryId, this.username);
    }

    static class UserSearchResultEntryComparator
    implements Comparator<UserSearchResultEntry> {
        private final boolean reversed;

        UserSearchResultEntryComparator(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(UserSearchResultEntry o1, UserSearchResultEntry o2) {
            if (o1.getSortByAttributeValue().compareTo(o2.sortByAttributeValue) == 0) {
                return Integer.compare(o1.directoryOrder, o2.directoryOrder) * -1;
            }
            if (this.reversed) {
                return o1.getSortByAttributeValue().compareTo(o2.sortByAttributeValue);
            }
            return o1.getSortByAttributeValue().compareTo(o2.sortByAttributeValue) * -1;
        }

        @Override
        public Comparator<UserSearchResultEntry> reversed() {
            return new UserSearchResultEntryComparator(true);
        }
    }
}

