/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlascompat.factory.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Version
implements Comparable<Version> {
    private static List<String> atlassianPrereleasePrefixOrder = Arrays.asList("snapshot", "od", "d", "build", "qr", "rel", "pre", "m", "eap", "alpha", "beta", "rc");
    private static HashMap<String, Version> versionCache = new HashMap();
    private final String version;
    private final String baseVersion;
    private final String prereleaseVersion;
    private final String[] parts;
    private final String[] prereleaseParts;

    public static Version of(String version) {
        return versionCache.computeIfAbsent(version, Version::new);
    }

    public final String get() {
        return this.version;
    }

    private Version(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+)*?[-+~]?.*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.version = version;
        String[] versionTypeSplit = version.split("[-+~]");
        this.baseVersion = versionTypeSplit[0];
        this.parts = this.baseVersion.split("\\.");
        this.prereleaseVersion = versionTypeSplit.length < 2 ? "" : version.substring(this.baseVersion.length() + 1);
        String prereleaseVersionPrepared = this.prereleaseVersion.replaceAll("([0-9])([a-zA-Z])", "$1-$2").replaceAll("([a-zA-Z])([0-9])", "$1-$2");
        String[] prereleasePartsSplit = prereleaseVersionPrepared.split("[-\\.+~]");
        this.prereleaseParts = prereleasePartsSplit.length == 1 && prereleasePartsSplit[0].isEmpty() ? new String[0] : prereleasePartsSplit;
    }

    @Override
    public int compareTo(Version that) {
        int i;
        if (that == null) {
            return 1;
        }
        int length = Math.max(this.parts.length, that.parts.length);
        for (i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < this.parts.length ? Integer.parseInt(this.parts[i]) : 0;
            int n = thatPart = i < that.parts.length ? Integer.parseInt(that.parts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        if (this.prereleaseParts.length == 0 && that.prereleaseParts.length == 0) {
            return 0;
        }
        if (this.prereleaseParts.length == 0) {
            return 1;
        }
        if (that.prereleaseParts.length == 0) {
            return -1;
        }
        length = Math.max(this.prereleaseParts.length, that.prereleaseParts.length);
        for (i = 0; i < length; ++i) {
            if (i >= this.prereleaseParts.length) {
                return -1;
            }
            if (i >= that.prereleaseParts.length) {
                return 1;
            }
            String thisPart = this.prereleaseParts[i].toLowerCase();
            String thatPart = that.prereleaseParts[i].toLowerCase();
            try {
                int thisPartInt = Integer.parseInt(thisPart);
                int thatPartInt = Integer.parseInt(thatPart);
                if (thisPartInt < thatPartInt) {
                    return -1;
                }
                if (thisPartInt <= thatPartInt) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                if (atlassianPrereleasePrefixOrder.contains(thisPart) && atlassianPrereleasePrefixOrder.contains(thatPart)) {
                    int thatPartPrefixIndex;
                    int thisPartPrefixIndex = atlassianPrereleasePrefixOrder.indexOf(thisPart);
                    if (thisPartPrefixIndex < (thatPartPrefixIndex = atlassianPrereleasePrefixOrder.indexOf(thatPart))) {
                        return -1;
                    }
                    if (thisPartPrefixIndex <= thatPartPrefixIndex) continue;
                    return 1;
                }
                if (thisPart.equals(thatPart)) continue;
                return thisPart.compareTo(thatPart);
            }
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }

    public String toString() {
        return this.version;
    }

    public boolean isLessThan(String that) {
        return this.isLessThan(Version.of(that));
    }

    public boolean isLessThan(Version that) {
        return this.compareTo(that) < 0;
    }

    public boolean isLessThanOrEqual(String that) {
        return this.isLessThanOrEqual(Version.of(that));
    }

    public boolean isLessThanOrEqual(Version that) {
        return this.compareTo(that) <= 0;
    }

    public boolean isGreaterThanOrEqual(String that) {
        return this.isGreaterThanOrEqual(Version.of(that));
    }

    public boolean isGreaterThanOrEqual(Version that) {
        return this.compareTo(that) >= 0;
    }

    public boolean isGreaterThan(String that) {
        return this.isGreaterThan(Version.of(that));
    }

    public boolean isGreaterThan(Version that) {
        return this.compareTo(that) > 0;
    }

    public String[] getParts() {
        return this.parts;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getPrereleaseVersion() {
        return this.prereleaseVersion;
    }

    public String[] getPrereleaseParts() {
        return this.prereleaseParts;
    }

    public int getMajorVersion() {
        return this.parts.length > 0 ? Integer.parseInt(this.parts[0]) : 0;
    }

    public int getMinorVersion() {
        return this.parts.length > 1 ? Integer.parseInt(this.parts[1]) : 0;
    }

    public int getPatchVersion() {
        return this.parts.length > 2 ? Integer.parseInt(this.parts[0]) : 0;
    }
}

