/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.validate.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.resolution.commons.validate.api.JsonSerializationFailedException;
import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.api.ValidationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidationResultImpl
implements ValidationResult {
    private final List<ValidationMessage> errors;
    private final List<ValidationMessage> warnings;
    private final Map<String, ValidationResult> childMap;
    private final List<ValidationResult> childList;
    private final ObjectWriter jsonWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();

    public ValidationResultImpl(@Nullable ValidationMessage errorMsg, @Nullable ValidationMessage warnMsg) {
        this.errors = new ArrayList<ValidationMessage>();
        this.warnings = new ArrayList<ValidationMessage>();
        this.childMap = new HashMap<String, ValidationResult>();
        this.childList = new ArrayList<ValidationResult>();
        if (errorMsg != null) {
            this.errors.add(errorMsg);
        }
        if (warnMsg != null) {
            this.warnings.add(warnMsg);
        }
    }

    public ValidationResultImpl() {
        this(null, null);
    }

    @Override
    @Nonnull
    public ValidationResult add(int index, ValidationResult child) {
        while (index >= this.childList.size()) {
            this.childList.add(null);
        }
        this.childList.set(index, child);
        return this;
    }

    @Override
    @Nonnull
    public ValidationResult add(ValidationResult child) {
        this.childList.add(child);
        return this;
    }

    @Override
    @Nonnull
    public ValidationResult add(String key, ValidationResult child) {
        this.childMap.put(key, child);
        return this;
    }

    @Override
    @Nonnull
    public ValidationResult add(String key, ValidationMessage errorMessage, @Nullable ValidationMessage warnMessage) {
        ValidationResultImpl child = new ValidationResultImpl(errorMessage, warnMessage);
        this.add(key, (ValidationResult)child);
        return this;
    }

    @Override
    @Nonnull
    public ValidationResult add(int index, ValidationMessage errorMessage, @Nullable ValidationMessage warnMessage) {
        ValidationResultImpl child = new ValidationResultImpl(errorMessage, warnMessage);
        this.add(index, (ValidationResult)child);
        return this;
    }

    @Override
    public ValidationResult addError(ValidationMessage errorMsg) {
        this.errors.add(errorMsg);
        return this;
    }

    @Override
    public ValidationResult addWarning(ValidationMessage warning) {
        this.warnings.add(warning);
        return this;
    }

    @Override
    @Nonnull
    public List<ValidationMessage> getErrors() {
        return this.errors;
    }

    @Override
    @Nonnull
    public List<ValidationMessage> getWarnings() {
        return this.warnings;
    }

    @Override
    @Nonnull
    public Map<String, ValidationResult> getMap() {
        return this.childMap;
    }

    @Override
    @Nonnull
    public List<ValidationResult> getList() {
        return this.childList;
    }

    @Override
    public boolean isValid() {
        return this.errors.isEmpty() && this.childMap.values().stream().allMatch(result -> result == null || result.isValid()) && this.childList.stream().allMatch(result -> result == null || result.isValid());
    }

    @Override
    public boolean isContainsWarnings() {
        if (!this.warnings.isEmpty()) {
            return true;
        }
        if (this.childMap.values().stream().anyMatch(result -> result != null && result.isContainsWarnings())) {
            return true;
        }
        return this.childList.stream().anyMatch(result -> result != null && result.isContainsWarnings());
    }

    @Override
    public String asJson() {
        try {
            return this.jsonWriter.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new JsonSerializationFailedException(e);
        }
    }
}

