/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl.jira;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import de.resolution.atlasauth.impl.AbstractAuthenticatorHook;
import de.resolution.atlasauth.impl.AuthenticatorHookException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent(value="authenticatorHook")
public class JiraAuthenticatorHook
extends AbstractAuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(JiraAuthenticatorHook.class);
    private final DefaultAuthenticator authenticator;
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final LoginService loginService;

    @Autowired
    public JiraAuthenticatorHook(@JiraImport TransactionTemplate transactionTemplate, @JiraImport EventPublisher eventPublisher, @JiraImport(value="jiraUserManager") UserManager userManager, @JiraImport LoginService loginService) {
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            this.authenticator = null;
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + "is not a DefaultAuthenticator.");
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
        this.loginService = loginService;
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nonnull Principal principal, boolean sdCustomerLogin) throws AuthenticatorHookException {
        ApplicationUser applicationUser = this.userManager.getUserByName(principal.getName());
        if (applicationUser == null) {
            throw new AuthenticatorHookException("Could not load application user for principal " + principal.getName());
        }
        if (!applicationUser.isActive()) {
            throw new AuthenticatorHookException("User is not active");
        }
        boolean authenticated = sdCustomerLogin ? this.loginSdCustomer(httpServletRequest, principal) : this.loginUser(httpServletRequest, httpServletResponse, principal);
        if (authenticated) {
            LoginEvent loginEvent = new LoginEvent(applicationUser);
            this.loginService.updateLastLoginTime(applicationUser);
            this.loginService.resetFailedLoginCount(applicationUser);
            this.eventPublisher.publish((Object)loginEvent);
        }
        return authenticated;
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private boolean loginUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal) throws AuthenticatorHookException {
        this.logger.debug("Invoking authoriseUserAndEstablishSession for {}", (Object)principal.getName());
        try {
            Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                return (Boolean)returnValue;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause());
        }
    }

    private boolean loginSdCustomer(HttpServletRequest httpServletRequest, Principal principal) throws AuthenticatorHookException {
        this.logger.debug("Adding SD-Customer {} to session context and returning true", (Object)principal.getName());
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("seraph_defaultauthenticator_user", (Object)principal);
        httpSession.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        return true;
    }
}

