/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JsonArrayCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.OrgJsonObject;
import com.github.wnameless.json.base.OrgJsonValue;
import com.github.wnameless.json.base.TransformIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.json.JSONArray;

public final class OrgJsonArray
implements JsonArrayCore<OrgJsonValue> {
    private final JSONArray jsonArray;

    public OrgJsonArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            throw new NullPointerException();
        }
        this.jsonArray = jsonArray;
    }

    @Override
    public void add(JsonSource jsonValue) {
        this.jsonArray.put(jsonValue.getSource());
    }

    @Override
    public void set(int index, JsonSource jsonValue) {
        this.jsonArray.put(index, jsonValue.getSource());
    }

    @Override
    public OrgJsonValue remove(int index) {
        return new OrgJsonValue(this.jsonArray.remove(index));
    }

    @Override
    public OrgJsonValue get(int index) {
        return new OrgJsonValue(this.jsonArray.get(index));
    }

    @Override
    public int size() {
        return this.jsonArray.length();
    }

    @Override
    public Iterator<OrgJsonValue> iterator() {
        return new TransformIterator<Object, OrgJsonValue>(this.jsonArray.iterator(), OrgJsonValue::new);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrgJsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrgJsonArray asArray() {
        return this;
    }

    @Override
    public OrgJsonValue asValue() {
        return new OrgJsonValue(this.jsonArray);
    }

    @Override
    public Object getSource() {
        return this.jsonArray;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgJsonArray)) {
            return false;
        }
        return this.jsonArray.similar(((OrgJsonArray)o).jsonArray);
    }

    public String toString() {
        return this.jsonArray.toString();
    }
}

