/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSyncPluginProperties {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncPluginProperties.class);
    private static final Properties properties = new Properties();

    private UserSyncPluginProperties() {
    }

    public static String get(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} : {}", (Object)key, properties.get(key));
        }
        return properties.getProperty(key);
    }

    static {
        InputStream is = UserSyncPluginProperties.class.getResourceAsStream("/plugin.properties");
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                logger.error("Loading plugin.properties failed!", (Throwable)e);
            }
        } else {
            logger.error("Cannot load plugin.properties, InputStream is null");
        }
        is = UserSyncPluginProperties.class.getResourceAsStream("/usersync-embedded.properties");
        if (is != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                logger.error("Loading /usersync-embedded.properties failed!", (Throwable)e);
            }
        } else {
            logger.error("Cannot load /usersync-embedded.properties, InputStream is null");
        }
    }
}

