/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractConnector;
import de.resolution.usersync.spi.HTTPConnectorConfiguration;
import javax.annotation.Nonnull;
import okhttp3.logging.HttpLoggingInterceptor;

public abstract class AbstractHTTPConnector<T extends HTTPConnectorConfiguration>
extends AbstractConnector<T> {
    private final HTTPWrapper httpWrapper;
    protected static final String HEADER_KEY_AUTHORIZATION = "Authorization";

    protected AbstractHTTPConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
        this.httpWrapper = new HTTPWrapper(configuration.getConnectTimeout(), configuration.getReadTimeout(), HttpLoggingInterceptor.Level.NONE);
    }

    @Override
    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp() {
        return true;
    }

    @Nonnull
    protected HTTPWrapper getHttpWrapper() {
        if (((HTTPConnectorConfiguration)this.configuration).getHttpLogLevel() == HttpLoggingInterceptor.Level.NONE) {
            return this.httpWrapper;
        }
        return new HTTPWrapper(((HTTPConnectorConfiguration)this.configuration).getConnectTimeout(), ((HTTPConnectorConfiguration)this.configuration).getReadTimeout(), ((HTTPConnectorConfiguration)this.configuration).getHttpLogLevel());
    }

    protected abstract String getAuthorizationHeaderValue();
}

