/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import de.resolution.retransform.frontend.TargetTypeMap;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.rest.entities.DirectorySelection;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorEntity {
    private final Connector<?> connector;
    private final SyncStatus syncStatus;
    private final Map<String, String> hostApplicationAttributes;
    private final DirectorySelection directorySelection;
    private final CronExpressionValidator cronExpressionValidator;
    private final ValidationResult validationResult;
    private final List<Notification> notifications;

    public ConnectorEntity(@Nonnull Connector<?> connector, @Nonnull ValidationResult validationResult, @Nullable Map<String, String> hostApplicationAttributes, @Nullable SyncStatus syncStatus, @Nonnull DirectorySelection directorySelection, @Nonnull List<Notification> notifications, CronExpressionValidator cronExpressionValidator) {
        this.connector = connector;
        this.validationResult = validationResult;
        this.syncStatus = syncStatus;
        this.hostApplicationAttributes = hostApplicationAttributes;
        this.directorySelection = directorySelection;
        this.notifications = notifications;
        this.cronExpressionValidator = cronExpressionValidator;
    }

    public String getUniqueId() {
        return this.connector.getUniqueId();
    }

    public ConnectorConfiguration getConfiguration() {
        return this.connector.getConfiguration();
    }

    public String getType() {
        return this.connector.getClass().getCanonicalName();
    }

    public String getTypeDisplayName() {
        return this.connector.getTypeDisplayName();
    }

    @JsonProperty
    List<String> getConnectorAttributes() {
        return this.connector.getConnectorAttributes();
    }

    public boolean isAllowCustomConnectorAttributes() {
        return this.connector.isAllowCustomConnectorAttributes();
    }

    public boolean isAllowCustomAttributeMapping() {
        return this.connector.isAllowCustomAttributeMapping();
    }

    public boolean isAllowSelectingFindByAttribute() {
        return this.connector.isAllowSelectingFindByAttribute();
    }

    public boolean isEditable() {
        return this.connector.isEditable();
    }

    public boolean isSelectableGroupAttribute() {
        return this.connector.isSelectableGroupAttribute();
    }

    public boolean isCleanupConfigurable() {
        return this.connector.isCleanupConfigurable();
    }

    public boolean isCanCopyUsers() {
        return this.connector.isCanCopyUsers();
    }

    public TargetTypeMap getAttributeMappingTemplates() {
        return this.connector.getAttributeMappingTemplates();
    }

    @JsonProperty
    Map<String, String> getHostApplicationAttributes() {
        if (this.hostApplicationAttributes != null) {
            return this.hostApplicationAttributes;
        }
        return Collections.emptyMap();
    }

    public long getLastUpdated() {
        return this.connector.getLastUpdated();
    }

    public String getLastUpdatedUTC() {
        return DateFormat.getDateTimeInstance().format(new Date(this.connector.getLastUpdated()));
    }

    public boolean isValid() {
        return this.validationResult.isValid();
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Nullable
    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public boolean isCanBeScheduled() {
        return this.connector.isCanBeScheduled();
    }

    public long getNextScheduledSync() {
        Object config = this.connector.getConfiguration();
        if (!config.isScheduled()) {
            return -1L;
        }
        return this.cronExpressionValidator.getNextScheduledSyncAsLong(config.getCronExpression());
    }

    public boolean isCanSync() {
        return this.connector.isCanSync();
    }

    public boolean isSyncEnabled() {
        return this.connector.getConfiguration().isSyncEnabled();
    }

    public boolean isCanSyncSingleUser() {
        return this.connector.isCanSyncSingleUser();
    }

    public boolean isSelectableDirectory() {
        return this.connector.isSelectableDirectory();
    }

    public boolean isAllowCreatingNewDirectory() {
        return this.connector.isAllowCreatingNewDirectory();
    }

    public boolean isAllowGroupConfiguration() {
        return this.connector.isAllowGroupConfiguration();
    }

    public DirectorySelection getDirectorySelection() {
        return this.directorySelection;
    }

    public boolean isAuthorizationRequired() {
        return this.connector.isAuthorizationRequired();
    }

    public String getAuthorizationCodeUrl() {
        return this.connector.getAuthorizationCodeUrl();
    }

    public boolean isCanHaveRequiredGroupsGroovyExpression() {
        return this.connector.isCanUseRequiredConnectorGroupsGroovy();
    }

    public boolean isNew() {
        return this.connector.isNew();
    }

    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp() {
        return this.connector.isCanOverrideDefaultConnectTimeoutForOkHttp();
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public boolean isCanHaveRequiredGroups() {
        return this.connector.isCanHaveRequiredGroups();
    }

    public boolean isHasProvisioningSettings() {
        return this.connector.isHasProvisioningSettings();
    }

    public boolean isCanFetchRequiredGroups() {
        return this.connector.isCanFetchRequiredConnectorGroups();
    }
}

