/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.rest.entities.ConnectorFactoryEntity;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.spi.ConnectorFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ConnectorFactoryRegistryImpl
implements ConnectorFactoryRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConnectorFactoryRegistryImpl.class);
    private final Map<String, ConnectorFactory<? extends Connector<?>, ? extends ConnectorConfiguration>> connectorMap = new HashMap();
    private final Map<String, ConnectorFactory<?, ?>> configurationMap = new HashMap();

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> void register(ConnectorFactory<C, K> connectorFactory) {
        String className = connectorFactory.getConnectorClass().getCanonicalName();
        if (this.connectorMap.containsKey(className)) {
            logger.warn("{} is already registered, replacing it now. This usually happens when the ConnectorFactory was not unregistered before.", (Object)className);
        }
        this.connectorMap.put(className, connectorFactory);
        this.configurationMap.put(connectorFactory.getConfigurationClass().getCanonicalName(), connectorFactory);
    }

    public void unregister(ConnectorFactory connectorFactory) {
        String className = connectorFactory.getConnectorClass().getCanonicalName();
        if (this.connectorMap.containsKey(className)) {
            this.connectorMap.remove(className);
            this.configurationMap.remove(connectorFactory.getConfigurationClass().getCanonicalName());
        } else {
            logger.warn("{} was not registered, nothing to do.", (Object)className);
        }
    }

    @Override
    public List<ConnectorFactoryEntity> getRegisteredConnectorFactoryEntities() {
        return this.connectorMap.values().stream().map(ConnectorFactoryEntity::new).collect(Collectors.toList());
    }

    @Override
    public Collection<ConnectorFactory<Connector<ConnectorConfiguration>, ConnectorConfiguration>> getRegisteredConnectorFactories() {
        return this.connectorMap.values().stream().map(factory2 -> factory2).collect(Collectors.toList());
    }

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> Optional<ConnectorFactory<C, K>> getConnectorFactory(String connectorClassName) {
        ConnectorFactory<? extends Connector<?>, ? extends ConnectorConfiguration> factory2 = this.connectorMap.get(connectorClassName);
        return Optional.ofNullable(factory2);
    }

    @Override
    public <C extends Connector<K>, K extends ConnectorConfiguration> Optional<ConnectorFactory<C, K>> getConnectorFactoryByConfiguration(String configurationClassName) {
        ConnectorFactory<?, ?> factory2 = this.configurationMap.get(configurationClassName);
        return Optional.ofNullable(factory2);
    }
}

