/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.utils.Parser;
import de.resolution.atlasuser.api.user.AttributeFilter;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.ListUtil;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.builtin.scim.ScimConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScimRequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(ScimRequestUtils.class);

    private ScimRequestUtils() {
    }

    @Nonnull
    static Set<String> parseMultiValuedAttributes(@Nullable String excludedAttributesString) {
        if (excludedAttributesString == null || excludedAttributesString.isEmpty()) {
            return Collections.emptySet();
        }
        String[] excludedAttributesArray = excludedAttributesString.split(",");
        return Stream.of(excludedAttributesArray).collect(Collectors.toSet());
    }

    @Nullable
    static Filter parseFilter(@Nullable String filterString) throws ScimException {
        if (filterString == null) {
            return null;
        }
        return Parser.parseFilter(filterString);
    }

    @Nonnull
    static List<AttributeFilter> convertToAttributeFilter(@Nullable Filter parsedFilter, @Nonnull ScimConnector scimConnector) throws ScimException {
        TransformationResults transformationResults;
        ArrayList<AttributeFilter> filters = new ArrayList<AttributeFilter>();
        if (parsedFilter == null) {
            return filters;
        }
        String attributeName = parsedFilter.getAttributePath().toString();
        String attributeValue = parsedFilter.getComparisonValue().asText();
        FilterType filterType = parsedFilter.getFilterType();
        if (filterType != FilterType.EQUAL) {
            throw new BadRequestException(filterType.getStringValue() + " is not supported", "invalidFilter");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(attributeName, attributeValue);
        logger.debug("incoming filter: {}", attributes);
        try {
            transformationResults = scimConnector.applyTransformations(attributes, null, null);
        }
        catch (TransformationFailedException e) {
            throw new ServerErrorException("Could not create filter because of failing transformation: " + e.getMessage(), null, e);
        }
        HashMap<String, Collection<String>> transformedAttributes = new HashMap<String, Collection<String>>(transformationResults.getTransformedAttributes());
        if (logger.isDebugEnabled()) {
            logger.debug("transformed filter: {}", (Object)JSONUtil.asJson(transformedAttributes));
        }
        for (Map.Entry stringCollectionEntry : transformedAttributes.entrySet()) {
            filters.add(AttributeFilter.equalTo(ListUtil.firstOrEmptyString(new ArrayList<String>((Collection)stringCollectionEntry.getValue())), (String)stringCollectionEntry.getKey()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Converted filters: {}", (Object)JSONUtil.asJson(filters));
        }
        return filters;
    }

    static int parseStartIndex(int startIndex) {
        return Math.max(startIndex - 1, 0);
    }

    static int parseCount(int count) {
        return Math.max(count, 0);
    }
}

