/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.group.ScimCoreGroup;
import de.resolution.usersync.builtin.scim.rest.AbstractResource;
import de.resolution.usersync.builtin.scim.rest.ListResponse;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import de.resolution.usersync.builtin.scim.rest.PatchRequest;
import de.resolution.usersync.builtin.scim.rest.ScimErrorResponseBuilder;
import de.resolution.usersync.builtin.scim.rest.ScimRequestUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="usersync/connector/{connectorId}/scim/v2/Groups")
@AnonymousAllowed
public class GroupResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GroupResource.class);
    private static final String MESSAGE_GROUPID_MUST_NOT_BE_EMPTY = "GroupId must not be empty";

    @Autowired
    public GroupResource(ConnectorService connectorService, PrivilegeChecker privilegeChecker, LicenseChecker licenseChecker) {
        super(connectorService, privilegeChecker, licenseChecker);
    }

    @GET
    @Produces(value={"application/json", "application/scim+json"})
    public Response getGroups(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="count") int count, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @QueryParam(value="filter") @Nullable String filter) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        logger.debug("getGroups, startIndex: {}, count: {}", (Object)startIndex, (Object)count);
        List<ScimCoreGroup> groups2 = scimConnector.getDirectoryGroups(ScimRequestUtils.parseStartIndex(startIndex), ScimRequestUtils.parseCount(count), ScimRequestUtils.parseFilter(filter), ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return this.createListResponse(groups2, ScimRequestUtils.parseStartIndex(startIndex));
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response getGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupname, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (groupname == null) {
            return new ScimErrorResponseBuilder().status(Response.Status.BAD_REQUEST).detail("groupid must not be null").build();
        }
        ScimCoreGroup scimGroup = scimConnector.getDirectoryGroup(groupname, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.ok((Object)JSONUtil.asJson(scimGroup)).build();
    }

    @Nonnull
    private Response createListResponse(@Nonnull List<ScimCoreGroup> groups2, int startIndex) {
        if (logger.isDebugEnabled()) {
            logger.debug("Create List Response for groups: {}", (Object)JSONUtil.asJson(groups2));
        }
        ListResponse.ListResponseBuilder builder = ListResponse.builder();
        builder.totalResults(groups2.size());
        builder.startIndex(startIndex + 1);
        for (ScimCoreGroup group : groups2) {
            builder.resource(group);
        }
        return Response.ok((Object)JSONUtil.asJson(builder.build())).build();
    }

    @POST
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response createGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (resourceString == null) {
            return new ScimErrorResponseBuilder().status(Response.Status.BAD_REQUEST).detail("request contains no resource string").build();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Create group: {}", (Object)StringUtil.sanitize(resourceString));
        }
        StructuredData data = StructuredData.parseJson(resourceString);
        ScimCoreGroup createdGroup = scimConnector.createDirectoryGroup(data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)JSONUtil.asJson(createdGroup)).build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response updateGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupname, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (groupname == null || groupname.isEmpty()) {
            throw new BadRequestException(MESSAGE_GROUPID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Modify group <{}>: {}", (Object)StringUtil.sanitize(groupname), (Object)StringUtil.sanitize(resourceString));
        }
        StructuredData data = StructuredData.parseJson(resourceString);
        ScimCoreGroup updatedGroup = scimConnector.updateDirectoryGroup(groupname, data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JSONUtil.asJson(updatedGroup)).build();
    }

    @PATCH
    @Path(value="{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response patchGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupname, @QueryParam(value="attributes") @Nullable String attribute, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (groupname == null || groupname.isEmpty()) {
            throw new BadRequestException(MESSAGE_GROUPID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        PatchRequest patchRequest = PatchRequest.fromJson(resourceString);
        block5: for (PatchRequest.PatchOperation operation : patchRequest.getOperations()) {
            StructuredData foundValues;
            if (!"members".equalsIgnoreCase(operation.getPath())) continue;
            List<String> membersValues = operation.getValue().isList() ? ((foundValues = operation.getValue().find("value.collect{it}")) != null && foundValues.isList() ? foundValues.asStringList() : Collections.emptyList()) : Collections.singletonList(operation.getValue().findString("value"));
            switch (operation.getOp()) {
                case ADD: {
                    scimConnector.assignDirectoryGroups(groupname, membersValues);
                    continue block5;
                }
                case REPLACE: {
                    scimConnector.setGroupMembers(groupname, new HashSet<String>(membersValues));
                    continue block5;
                }
                case REMOVE: {
                    scimConnector.unassignDirectoryGroups(groupname, membersValues);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation.getOp()));
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response deleteGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupname) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (groupname == null || groupname.isEmpty()) {
            throw new BadRequestException(MESSAGE_GROUPID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        scimConnector.deleteDirectoryGroup(groupname);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response getGroupsByPost() throws NotImplementedException {
        throw new NotImplementedException("This endpoint is not implemented");
    }
}

