/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.gsuite;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.gsuite.GSuiteConnector;
import de.resolution.usersync.builtin.gsuite.GSuiteConnectorConfiguration;
import de.resolution.usersync.builtin.gsuite.GSuiteConnectorConfigurationImpl;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractOAuthConnectorFactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="gsuiteConnectorFactory")
public class GSuiteConnectorFactory
extends AbstractOAuthConnectorFactory<GSuiteConnector, GSuiteConnectorConfiguration> {
    static final String NAME = "Google Cloud Identity";
    private static final String DESCRIPTION = "Connector using the Google Cloud Identity API (former G Suite)";

    @Inject
    public GSuiteConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public GSuiteConnector create(@Nonnull GSuiteConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new GSuiteConnector(this.connectorService, this.atlasUserAdapter, configuration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public Class<GSuiteConnector> getConnectorClass() {
        return GSuiteConnector.class;
    }

    @Override
    @Nonnull
    public Class<GSuiteConnectorConfiguration> getConfigurationClass() {
        return GSuiteConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    @Nonnull
    public GSuiteConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        GSuiteConnectorConfigurationImpl mutableConfig = new GSuiteConnectorConfigurationImpl();
        mutableConfig.setName("new Google Cloud Identity");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public String getSingleSyncInputDescription() {
        return "Please enter the username of the Google Cloud Identity user to update.";
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editGSuiteConnector.json";
    }

    @Override
    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        attributeTransformationConfigs.add(GSuiteConnectorConfigurationImpl.ACTIVE_TRANSFORMATION);
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull GSuiteConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        if (config.isFetchProfilePicture()) {
            boolean profilePictureDataIsMapped;
            boolean bl = profilePictureDataIsMapped = config.getAttributeTransformationConfigs().stream().filter(attributeTransformationConfig -> attributeTransformationConfig.getTarget().getName().equals("ATTR_PROFILE_PICTURE_DATA")).collect(Collectors.toSet()).size() == 1;
            if (!profilePictureDataIsMapped) {
                validationResult.add("fetchProfilePicture", null, ValidationMessage.create("The attribute mapping does not contain a mapping for \"Profile Picture\". Syncing profile pictures will only work correctly if this attribute is mapped."));
            }
        }
        return validationResult;
    }
}

