/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.impl.ImmutableSyncUserResult;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(value={"operation", "success"}, allowGetters=true)
public interface SyncUserResult {
    public AtlasUserResult getAtlasUserResult();

    public TransformationResults getTransformationResults();

    public boolean isSuccess();

    public Operation getOperation();

    public String getMessage();

    @JsonCreator
    public static SyncUserResult create(@Nullable @JsonProperty(value="transformationResults") TransformationResults transformationResults, @Nullable @JsonProperty(value="atlasUserResult") ImmutableAtlasUserResult atlasUserResult, @Nullable @JsonProperty(value="message") String message) {
        return new ImmutableSyncUserResult(transformationResults, atlasUserResult, message);
    }

    public static SyncUserResult create(@Nonnull TransformationResults transformationResults) {
        return SyncUserResult.create(transformationResults, null, null);
    }

    public static SyncUserResult create(@Nonnull TransformationResults transformationResults, String message) {
        return SyncUserResult.create(transformationResults, null, message);
    }

    public static SyncUserResult create(@Nonnull AtlasUserResult atlasUserResult) {
        return SyncUserResult.create(TransformationResults.createEmptyNonDrop(), atlasUserResult);
    }

    public static SyncUserResult create(@Nullable TransformationResults transformationResults, @Nullable AtlasUserResult atlasUserResult) {
        return new ImmutableSyncUserResult(transformationResults, atlasUserResult, null);
    }

    public static SyncUserResult fromJson(@Nonnull String resultJson) {
        return JSONUtil.fromJson(resultJson, SyncUserResult.class);
    }

    public static enum Operation {
        ADDED,
        DELETED,
        UPDATED,
        NOT_MODIFIED,
        NONE,
        FILTERED,
        FAILED;

    }
}

