/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.exception.UserSyncRuntimeException;
import de.resolution.usersync.impl.requiredgroups.GroovyBasedRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RegexBasedRequiredGroupChecker;
import de.resolution.usersync.spi.ConnectorConfiguration;
import javax.annotation.Nonnull;

public interface RequiredGroupChecker {
    public static RequiredGroupChecker create(@Nonnull ConnectorConfiguration configuration) throws GroovyBasedRequiredGroupChecker.GroovyCompilationFailedException {
        if (configuration.isUseRequiredConnectorGroupsGroovy()) {
            try {
                String groovyCode = configuration.getRequiredConnectorGroupsGroovy();
                if (groovyCode == null || groovyCode.trim().isEmpty()) {
                    throw new UserSyncRuntimeException("Groovy Code must not be null or empty, this should have been handled during validation");
                }
                return RequiredGroupChecker.create(groovyCode);
            }
            catch (Exception e) {
                throw new UserSyncRuntimeException("Failed to create RequiredGroupChecker, this should have been handled during validation", e);
            }
        }
        return new RegexBasedRequiredGroupChecker(configuration.getRequiredConnectorGroups());
    }

    public static RequiredGroupChecker create(@Nonnull String groovyCode) throws GroovyBasedRequiredGroupChecker.GroovyCompilationFailedException {
        return GroovyBasedRequiredGroupChecker.create(groovyCode);
    }

    public boolean isRequiredGroup(ConnectorGroup var1) throws RequiredGroupCheckFailedException;

    public static class RequiredGroupCheckFailedException
    extends RuntimeException {
        public RequiredGroupCheckFailedException(Exception cause) {
            super(cause.getMessage(), cause);
        }

        public RequiredGroupCheckFailedException(String message) {
            super(message);
        }
    }
}

