/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.usersync.impl.NotificationImpl;
import javax.annotation.Nonnull;

public interface Notification {
    public static final String ID_PREFIX_CONNECTOR = "CON";

    public static Notification createforConnector(@Nonnull String message, @Nonnull Level level, @Nonnull String msgId, String connectorUID) {
        return new NotificationImpl(message, level, msgId, ID_PREFIX_CONNECTOR + connectorUID);
    }

    public String getMessage();

    public Level getLevel();

    public String getMessageId();

    public String getContextId();

    default public String getAppearance() {
        switch (this.getLevel()) {
            case WARNING: {
                return "warning";
            }
            case ERROR: {
                return "error";
            }
        }
        return "info";
    }

    public static enum Level {
        INFO,
        WARNING,
        ERROR;

    }
}

