/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.commons.data.StructuredData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConnectorGroup {
    @Nonnull
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String groupDataJson;
    @Nullable
    private final StructuredData structuredData;

    public ConnectorGroup(@Nonnull String id, @Nullable String name, @Nonnull StructuredData structuredData) {
        this.id = id;
        this.name = name;
        this.groupDataJson = null;
        this.structuredData = structuredData;
    }

    public ConnectorGroup(@Nonnull String id, @Nullable String name, @Nonnull String groupDataJson) {
        this.id = id;
        this.name = name;
        this.groupDataJson = groupDataJson;
        this.structuredData = null;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public StructuredData getGroupAttributes() {
        if (this.structuredData != null) {
            return this.structuredData;
        }
        if (this.groupDataJson != null) {
            return StructuredData.parseJson(this.groupDataJson);
        }
        throw new RuntimeException("Neither groupDataJson nor structuredData representation of group was provided.");
    }
}

