/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.config.TargetValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TargetValidatorImpl
implements TargetValidator {
    private final CommunardoUserProfileAdapter communardoUserProfileAdapter;

    @Autowired
    public TargetValidatorImpl(CommunardoUserProfileAdapter communardoUserProfileAdapter) {
        this.communardoUserProfileAdapter = communardoUserProfileAdapter;
    }

    @Override
    public ValidationResult validate(Target target, AttributeTransformationConfig attributeTransformationConfig) {
        ValidationResult validationResult = ValidationResult.create();
        if (target.getType() == null) {
            validationResult.add("type", "Type must be set");
        }
        if (target.getType() != Target.Type.NONE && StringUtil.isNullOrEmpty(target.getName())) {
            validationResult.add("name", "Please enter a value.");
        }
        if (target.getName() != null && target.getName().startsWith("COMMUNARDO_UP.")) {
            try {
                int fieldId = Integer.parseInt(target.getName().substring("COMMUNARDO_UP.".length()));
                if (!this.communardoUserProfileAdapter.getAvailableAttributes().containsKey(fieldId)) {
                    validationResult.addWarning("Attribute " + target.getName() + " is not configured in Communardo User Profiles and will be ignored.");
                }
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                validationResult.addError("Failed to get id-part from " + target.getName());
            }
        }
        return validationResult;
    }
}

