/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.commons.validate.api.Validatable;
import de.resolution.commons.validate.api.ValidationResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Transformations
implements Validatable {
    private final boolean toLowerCase;
    private final RegexAndReplacementWrapper regexAndReplacement;
    private final SplitAttribute splitAttribute;
    private final AddConstant addConstant;

    @JsonCreator
    public Transformations(@JsonProperty(value="toLowerCase") boolean toLowerCase, @JsonProperty(value="regexAndReplacement") RegexAndReplacementWrapper regexAndReplacement, @JsonProperty(value="splitAttribute") SplitAttribute splitAttribute, @JsonProperty(value="addConstant") AddConstant addConstant) {
        this.toLowerCase = toLowerCase;
        this.regexAndReplacement = regexAndReplacement == null ? new RegexAndReplacementWrapper(false, null, null) : regexAndReplacement;
        this.splitAttribute = splitAttribute == null ? new SplitAttribute(false, null) : splitAttribute;
        this.addConstant = addConstant == null ? new AddConstant(false, null) : addConstant;
    }

    public boolean isToLowerCase() {
        return this.toLowerCase;
    }

    public RegexAndReplacementWrapper getRegexAndReplacement() {
        return this.regexAndReplacement;
    }

    public SplitAttribute getSplitAttribute() {
        return this.splitAttribute;
    }

    public AddConstant getAddConstant() {
        return this.addConstant;
    }

    public static Transformations createToLowerCase(boolean toLowerCase) {
        return new Transformations(toLowerCase, null, null, null);
    }

    public static Transformations createRegexAndReplacement(boolean toLowerCase, DropOption option, List<RegexAndReplacement> entries) {
        RegexAndReplacementWrapper wrapper = new RegexAndReplacementWrapper(true, entries, option);
        return new Transformations(toLowerCase, wrapper, null, null);
    }

    public static Transformations createEmpty() {
        return new Transformations(false, null, null, null);
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = ValidationResult.create();
        result.add("regexAndReplacement", this.regexAndReplacement.validate());
        result.add("splitAttribute", this.splitAttribute.validate());
        result.add("addConstant", this.addConstant.validate());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transformations that = (Transformations)o;
        return this.toLowerCase == that.toLowerCase && Objects.equals(this.regexAndReplacement, that.regexAndReplacement) && Objects.equals(this.splitAttribute, that.splitAttribute) && Objects.equals(this.addConstant, that.addConstant);
    }

    public int hashCode() {
        return Objects.hash(this.toLowerCase, this.regexAndReplacement, this.splitAttribute, this.addConstant);
    }

    public static class AddConstant
    implements Validatable {
        private final boolean enabled;
        private final List<String> values;

        @JsonCreator
        public AddConstant(@JsonProperty(value="enabled") boolean enabled, @Nullable @JsonProperty(value="values") List<String> values2) {
            this.enabled = enabled;
            this.values = values2 == null ? Collections.emptyList() : values2;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        @Override
        public ValidationResult validate() {
            ValidationResult result = ValidationResult.create();
            if (this.enabled) {
                ValidationResult valueResult = ValidationResult.create();
                result.add(valueResult);
                int i = 0;
                while (i < this.values.size()) {
                    if (this.values.get(i) == null || this.values.get(i).isEmpty()) {
                        valueResult.add(i, "Value must not be empty");
                    }
                    ++i;
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddConstant that = (AddConstant)o;
            return this.enabled == that.enabled && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.values);
        }
    }

    public static enum DropOption {
        DROP_USER_IF_NOT_APPLIED,
        DROP_ATTRIBUTE_IF_NOT_APPLIED,
        DROP_VALUE_IF_NOT_APPLIED,
        NONE;

    }

    public static class RegexAndReplacementWrapper
    implements Validatable {
        private final boolean enabled;
        private final List<RegexAndReplacement> items;
        private final DropOption dropOption;

        @JsonCreator
        public RegexAndReplacementWrapper(@JsonProperty(value="enabled") boolean enabled, @Nullable @JsonProperty(value="items") List<RegexAndReplacement> items, @Nullable @JsonProperty(value="dropOption") DropOption dropOption) {
            this.enabled = enabled;
            this.items = items == null ? Collections.emptyList() : items;
            this.dropOption = dropOption == null ? DropOption.NONE : dropOption;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public List<RegexAndReplacement> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        public DropOption getDropOption() {
            return this.dropOption;
        }

        @Override
        public ValidationResult validate() {
            ValidationResult result = ValidationResult.create();
            if (this.enabled) {
                ValidationResult itemResult = ValidationResult.create();
                result.add(itemResult);
                int i = 0;
                while (i < this.items.size()) {
                    if (!this.items.get(i).validate()) {
                        itemResult.add(i, "Regex is invalid");
                    }
                    ++i;
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegexAndReplacementWrapper that = (RegexAndReplacementWrapper)o;
            return this.enabled == that.enabled && Objects.equals(this.items, that.items) && this.dropOption == that.dropOption;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.enabled, this.items, this.dropOption});
        }
    }

    public static class SplitAttribute
    implements Validatable {
        private final boolean enabled;
        private final String separator;

        @JsonCreator
        public SplitAttribute(@JsonProperty(value="enabled") boolean enabled, @Nullable @JsonProperty(value="separator") String separator) {
            this.enabled = enabled;
            this.separator = separator;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nullable
        public String getSeparator() {
            return this.separator;
        }

        @Override
        public ValidationResult validate() {
            ValidationResult result = ValidationResult.create();
            if (this.enabled && (this.separator == null || this.separator.isEmpty())) {
                result.add("separator", "Separator must be set");
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitAttribute that = (SplitAttribute)o;
            return this.enabled == that.enabled && Objects.equals(this.separator, that.separator);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.separator);
        }
    }
}

