/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Target {
    private final Type type;
    private final String name;

    @JsonCreator
    public Target(@JsonProperty(value="type") Type type, @JsonProperty(value="name") String name) {
        this.type = type;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Target target = (Target)o;
        return this.type == target.type && Objects.equals(this.name, target.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public static Target createSystem(String name) {
        return new Target(Type.SYSTEM, name);
    }

    public static Target createCrowd(String name) {
        return new Target(Type.CROWD, name);
    }

    public static Target createProfile(String name) {
        return new Target(Type.PROFILE, name);
    }

    public static Target createEmpty() {
        return new Target(Type.NONE, "None");
    }

    public static enum Type {
        NONE,
        SYSTEM,
        PROFILE,
        CROWD,
        CONFLUENCE_CP,
        LINCHPIN,
        JIRA_EPROP;

    }
}

