/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util.boundedregex;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.RegexAndReplacementResult;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.DEFAULT)
public class RegexAndReplacement {
    private final String regex;
    @Nullable
    private final String replacement;
    @Nullable
    private final String message;
    private Exception exception = null;
    private Pattern pattern;
    private boolean regexIsValid;
    private final long timeout;
    private static final long DEFAULT_TIMEOUT = 2000L;

    public RegexAndReplacement(@Nonnull RegexAndReplacement other) {
        this(other.getRegex(), other.getReplacement(), other.timeout);
    }

    @JsonCreator
    public RegexAndReplacement(@JsonProperty(value="regex") String regex, @JsonProperty(value="replacement") String replacement) {
        this(regex, replacement, 2000L);
    }

    public RegexAndReplacement(String regex, @Nullable String replacement, long timeout2) {
        this.timeout = timeout2;
        this.regex = regex;
        String msg = null;
        if (regex != null && !regex.trim().isEmpty()) {
            try {
                this.pattern = Pattern.compile(regex);
                this.regexIsValid = true;
            }
            catch (Exception e) {
                this.regexIsValid = false;
                msg = e.getMessage();
                this.exception = e;
            }
        } else {
            this.regexIsValid = false;
            msg = "must be set";
        }
        this.message = msg;
        this.replacement = replacement;
    }

    @Nonnull
    public String getRegex() {
        return this.regex;
    }

    @Nullable
    public String getReplacement() {
        return this.replacement;
    }

    @JsonIgnore
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public boolean isRegexValid() {
        return this.regexIsValid;
    }

    @JsonIgnore
    public boolean isReplacementPresent() {
        return this.replacement != null && !this.replacement.trim().isEmpty();
    }

    @JsonIgnore
    public boolean validate() {
        return this.isRegexValid() && this.isReplacementPresent();
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof RegexAndReplacement) {
            RegexAndReplacement other = (RegexAndReplacement)otherObj;
            return Objects.equals(this.regex, other.regex) && Objects.equals(this.replacement, other.replacement);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.regex, this.replacement);
    }

    @JsonIgnore
    public Optional<String> apply(String value) throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        if (!this.validate()) {
            return Optional.empty();
        }
        if (!BoundedRegex.matches(this.pattern, value, this.timeout)) {
            return Optional.empty();
        }
        return Optional.of(BoundedRegex.replaceAll(this.pattern, value, this.replacement, this.timeout));
    }

    public static boolean allValid(List<RegexAndReplacement> regexAndReplacementList) {
        return regexAndReplacementList.stream().allMatch(RegexAndReplacement::validate);
    }

    public static RegexAndReplacementResult apply(String value, Iterable<RegexAndReplacement> regexAndReplacements) {
        int index = 0;
        for (RegexAndReplacement regexAndReplacement : regexAndReplacements) {
            if (regexAndReplacement.exception != null) {
                return new RegexAndReplacementResult(false, null, regexAndReplacement.message, index, null, regexAndReplacement.regex, regexAndReplacement.replacement);
            }
            try {
                Optional<String> result = regexAndReplacement.apply(value);
                if (result.isPresent()) {
                    return new RegexAndReplacementResult(true, result.get(), null, index, value, regexAndReplacement.regex, regexAndReplacement.replacement);
                }
            }
            catch (Exception e) {
                return new RegexAndReplacementResult(false, null, e.getMessage(), index, value, regexAndReplacement.regex, regexAndReplacement.replacement);
            }
            ++index;
        }
        return new RegexAndReplacementResult(true, null, "no match", -1, value, null, null);
    }

    public static RegexAndReplacementResult checkValid(Iterable<RegexAndReplacement> regexAndReplacements) {
        int index = 0;
        for (RegexAndReplacement regexAndReplacement : regexAndReplacements) {
            if (regexAndReplacement.exception != null) {
                return new RegexAndReplacementResult(false, null, regexAndReplacement.message, index, null, null, null);
            }
            ++index;
        }
        return new RegexAndReplacementResult(true, null, "no match", -1, null, null, null);
    }

    public String toString() {
        return "RegexAndReplacement{regex='" + this.regex + '\'' + ", replacement='" + this.replacement + '\'' + '}';
    }
}

