/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util.boundedregex;

import de.resolution.commons.util.boundedregex.CancelControl;
import de.resolution.commons.util.boundedregex.ExecutionRuntimeException;
import de.resolution.commons.util.boundedregex.InterruptableCharSequence;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BoundedRegex {
    private BoundedRegex() {
    }

    public static boolean matches(String regex, String input, long timeout2) throws TimeoutExceededException {
        return BoundedRegex.matches(Pattern.compile(regex), input, timeout2);
    }

    public static boolean matches(Pattern pattern, String input, long timeout2) throws TimeoutExceededException {
        if (timeout2 <= 0L) {
            return pattern.matcher(input).matches();
        }
        CancelControl cc = new CancelControl();
        CompletableFuture<Boolean> cf = CompletableFuture.supplyAsync(() -> {
            Matcher matcher = pattern.matcher(new InterruptableCharSequence(input, cc));
            return matcher.matches();
        });
        return new AsyncRunner<Boolean>(cf, cc).getResult(pattern, input, timeout2);
    }

    public static String replaceAll(String regex, String input, String replacement, long timeout2) throws TimeoutExceededException {
        return BoundedRegex.replaceAll(Pattern.compile(regex), input, replacement, timeout2);
    }

    public static String replaceAll(Pattern pattern, String input, String replacement, long timeout2) throws TimeoutExceededException {
        if (timeout2 <= 0L) {
            return pattern.matcher(input).replaceAll(replacement);
        }
        CancelControl cc = new CancelControl();
        CompletableFuture<String> cf = CompletableFuture.supplyAsync(() -> {
            Matcher matcher = pattern.matcher(new InterruptableCharSequence(input, cc));
            return matcher.replaceAll(replacement);
        });
        return new AsyncRunner<String>(cf, cc).getResult(pattern, input, timeout2);
    }

    private static class AsyncRunner<T> {
        private final CompletableFuture<T> innerFuture;
        private final CancelControl cancelControl;

        public AsyncRunner(CompletableFuture<T> innerFuture, CancelControl cancelControl) {
            this.innerFuture = innerFuture;
            this.cancelControl = cancelControl;
        }

        public T getResult(Pattern pattern, String input, long timeout2) throws TimeoutExceededException {
            try {
                return this.innerFuture.get(timeout2, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.cancelControl.cancel();
                throw new TimeoutExceededException(pattern, input, timeout2);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new ExecutionRuntimeException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TimeoutExceededException(pattern, input, timeout2);
            }
        }
    }
}

