/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.net;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressString;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPRangeChecker {
    private static final Logger logger = LoggerFactory.getLogger(IPRangeChecker.class);
    private static final String IP_ADDRESS_OR_RANGE_CHECK_FAILED_LOG_TEXT = "Could not determine whether {} is single address or range and thus need to behave as if verification has failed.";

    private IPRangeChecker() {
    }

    public static boolean isInRange(@Nonnull HttpServletRequest servletRequest, @Nonnull List<String> allowedIpRanges) {
        return IPRangeChecker.isInRange(servletRequest, allowedIpRanges, null, null);
    }

    public static boolean isInRange(@Nonnull HttpServletRequest servletRequest, @Nonnull List<String> allowedIpRanges, @Nullable String realIpAddressHeaderName, @Nullable List<String> trustedReverseProxyIpAddresses) {
        String realIpAddress = IPRangeChecker.getClientIpAddress(servletRequest, realIpAddressHeaderName, trustedReverseProxyIpAddresses);
        return IPRangeChecker.isInRange(realIpAddress, allowedIpRanges);
    }

    @Nullable
    public static String getClientIpAddress(@Nonnull HttpServletRequest servletRequest, @Nullable String realIpAddressHeaderName, @Nullable List<String> trustedReverseProxyIpAddresses) {
        String realIpAddressHeaderValue;
        if (trustedReverseProxyIpAddresses == null || realIpAddressHeaderName == null) {
            return servletRequest.getRemoteAddr();
        }
        if (!IPRangeChecker.isTrustedReverseProxyIpAddress(trustedReverseProxyIpAddresses, servletRequest.getRemoteAddr())) {
            return servletRequest.getRemoteAddr();
        }
        String realIpAddress = null;
        if (!realIpAddressHeaderName.isEmpty() && !realIpAddressHeaderName.equals("Forwarded") && servletRequest.getHeader(realIpAddressHeaderName) != null) {
            realIpAddressHeaderValue = servletRequest.getHeader(realIpAddressHeaderName);
            logger.trace("{} header contains: {}", (Object)realIpAddressHeaderName, (Object)realIpAddressHeaderValue);
            String[] splitted = realIpAddressHeaderValue.split("\\s*,\\s*");
            if (splitted.length > 0) {
                realIpAddress = splitted[0].trim();
            }
        }
        if (!realIpAddressHeaderName.isEmpty() && realIpAddressHeaderName.equals("Forwarded") && servletRequest.getHeader(realIpAddressHeaderName) != null) {
            realIpAddressHeaderValue = servletRequest.getHeader(realIpAddressHeaderName);
            logger.trace("Forwarded header contains: {}", (Object)realIpAddressHeaderValue);
            String[] splittedByComma = realIpAddressHeaderValue.split("\\s*,\\s*");
            if (splittedByComma.length > 0 && !splittedByComma[0].trim().contains(";") && splittedByComma[0].trim().toLowerCase().contains("for")) {
                realIpAddress = splittedByComma[0].trim().toLowerCase().replace("for", "").replace("=", "").replace("\"", "").trim();
            }
            if (splittedByComma.length > 0 && splittedByComma[0].trim().contains(";") && splittedByComma[0].trim().toLowerCase().contains("for")) {
                String[] splittedBySemicolon;
                for (String forwardedPart : splittedBySemicolon = splittedByComma[0].trim().split("\\s*;\\s*")) {
                    if (!forwardedPart.toLowerCase().contains("for")) continue;
                    realIpAddress = forwardedPart.trim().toLowerCase().replace("for", "").replace("=", "").replace("\"", "").trim();
                }
            }
        }
        if (realIpAddress != null && !realIpAddress.isEmpty()) {
            HostName hostName = new HostName(realIpAddress);
            realIpAddress = hostName.getAddress() != null ? hostName.getAddress().toString() : null;
        }
        if (realIpAddress != null && !realIpAddress.isEmpty() && new IPAddressString(realIpAddress).isValid()) {
            logger.trace("Got IP Address from {} header: {}", (Object)realIpAddressHeaderName, (Object)realIpAddress);
            return realIpAddress;
        }
        return servletRequest.getRemoteAddr();
    }

    @Nullable
    private static String getClientIpAddressWithoutPortNumber(@Nonnull String realIpAddress) {
        HostName hostName = new HostName(realIpAddress);
        if (hostName.getAddress() != null) {
            return hostName.getAddress().toString();
        }
        return null;
    }

    public static boolean isInRange(@Nullable String sourceAddress, @Nullable List<String> allowedRanges) {
        if (allowedRanges == null || allowedRanges.isEmpty()) {
            return true;
        }
        if (sourceAddress != null && !sourceAddress.isEmpty()) {
            sourceAddress = IPRangeChecker.getClientIpAddressWithoutPortNumber(sourceAddress);
        }
        if (sourceAddress == null) {
            logger.error("Couldn't read client IP address and therefore need to assume that verification failed.");
            return false;
        }
        String finalSourceAddress = sourceAddress;
        return allowedRanges.stream().anyMatch(allowedIpOrRangeStr -> IPRangeChecker.validateSingleIpOrCidr(allowedIpOrRangeStr, finalSourceAddress));
    }

    private static boolean validateSingleIpOrCidr(@Nonnull String allowedAddressOrRangeStr, @Nullable String sourceAddress) {
        Optional<Boolean> isSingleAddress = IPRangeChecker.isSingleAddress(allowedAddressOrRangeStr);
        if (!isSingleAddress.isPresent()) {
            logger.warn(IP_ADDRESS_OR_RANGE_CHECK_FAILED_LOG_TEXT, (Object)allowedAddressOrRangeStr);
            return false;
        }
        if (Boolean.FALSE.equals(isSingleAddress.get())) {
            try {
                IPAddress clientIpAddress = new IPAddressString(sourceAddress).toAddress();
                IPAddress allowedRangeCidr = new IPAddressString(allowedAddressOrRangeStr).toAddress();
                IPAddress allowedRangeCidrStartIp = allowedRangeCidr.toZeroHost();
                IPAddress allowedRangeCidrEndIp = allowedRangeCidr.toMaxHost();
                logger.debug("Allowed IP range start/ end: {} / {}", (Object)allowedRangeCidrStartIp, (Object)allowedRangeCidrEndIp);
                IPAddressSeqRange ipRange = allowedRangeCidrStartIp.toSequentialRange(allowedRangeCidrEndIp);
                return ipRange.contains(clientIpAddress);
            }
            catch (AddressStringException e) {
                return false;
            }
        }
        try {
            IPAddress ipAddress = new IPAddressString(allowedAddressOrRangeStr).toAddress();
            return ipAddress.contains(new IPAddressString(sourceAddress).getAddress());
        }
        catch (AddressStringException e) {
            return false;
        }
    }

    @Nonnull
    private static Optional<Boolean> isSingleAddress(@Nonnull String allowedAddressOrRangeStr) {
        try {
            IPAddress allowedAddressOrRangeIpAddress = new IPAddressString(allowedAddressOrRangeStr).toAddress();
            if (allowedAddressOrRangeIpAddress.getNetworkPrefixLength() == null) {
                return Optional.of(true);
            }
            if (allowedAddressOrRangeIpAddress.isIPv4() && allowedAddressOrRangeIpAddress.getNetworkPrefixLength().equals(32)) {
                return Optional.of(true);
            }
            if (allowedAddressOrRangeIpAddress.isIPv6() && allowedAddressOrRangeIpAddress.getNetworkPrefixLength().equals(128)) {
                return Optional.of(true);
            }
        }
        catch (AddressStringException e) {
            return Optional.empty();
        }
        return Optional.of(false);
    }

    private static boolean isTrustedReverseProxyIpAddress(@Nonnull List<String> trustedReverseProxyIpAddresses, @Nullable String reverseProxyIpAddress) {
        for (String trustedIpAddressOrRange : trustedReverseProxyIpAddresses) {
            boolean isMatch = IPRangeChecker.validateSingleIpOrCidr(trustedIpAddressOrRange, reverseProxyIpAddress);
            logger.trace("Trusted IP address or range {} contains reverse proxy IP address {} = {}", new Object[]{trustedIpAddressOrRange, reverseProxyIpAddress, isMatch});
            if (!isMatch) continue;
            return true;
        }
        logger.debug("None of our trusted reverse proxy IP addresses matched the one from the request. Won't read real client IP from request.");
        return false;
    }
}

