/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.net;

import de.resolution.commons.net.HTTPWrapperException;
import de.resolution.commons.net.ResponseWrapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HTTPWrapper.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private final OkHttpClient okHttpClient;
    private final Map<String, Object> defaultHeaders = new HashMap<String, Object>();

    public HTTPWrapper() {
        this.okHttpClient = new OkHttpClient();
    }

    public HTTPWrapper(int connectTimeout, int readTimeout, @Nonnull HttpLoggingInterceptor.Level httpLogLevel) {
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(connectTimeout, TimeUnit.SECONDS).readTimeout(readTimeout, TimeUnit.SECONDS).addInterceptor(this.createHttpLoggingInterceptor(httpLogLevel)).build();
    }

    public void addDefaultHeader(@Nonnull String name, @Nonnull Object value) {
        this.defaultHeaders.put(name, value);
    }

    @Nullable
    public Object removeDefaultHeader(@Nonnull String name) {
        return this.defaultHeaders.remove(name);
    }

    @Nonnull
    public ResponseWrapper get(@Nonnull String url) {
        return this.get(url, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper get(@Nonnull HttpUrl url, @Nonnull Map<String, ?> headers) {
        return this.get(url.toString(), headers);
    }

    @Nonnull
    public ResponseWrapper get(@Nonnull String url, @Nonnull Map<String, ?> headers) {
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.defaultHeaders.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(reqBuilder.build());
    }

    @Nonnull
    public ResponseWrapper postAsForm(@Nonnull String url, @Nonnull Map<Object, Object> formFields) {
        return this.postAsForm(url, formFields, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper postAsForm(@Nonnull String url, @Nonnull Map<Object, Object> formFields, @Nonnull Map<String, ?> headers) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        formFields.forEach((k, v) -> formBuilder.add(k.toString(), v.toString()));
        Request.Builder reqBuilder = new Request.Builder().url(url).post(formBuilder.build()).addHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
        this.defaultHeaders.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(reqBuilder.build());
    }

    @Nonnull
    public ResponseWrapper putAsForm(@Nonnull String url, @Nonnull Map<Object, Object> formFields) {
        return this.putAsForm(url, formFields, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper putAsForm(@Nonnull String url, @Nonnull Map<Object, Object> formFields, @Nonnull Map<String, ?> headers) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        formFields.forEach((k, v) -> formBuilder.add(k.toString(), v.toString()));
        Request.Builder reqBuilder = new Request.Builder().url(url).put(formBuilder.build()).addHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
        this.defaultHeaders.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(reqBuilder.build());
    }

    @Nonnull
    public ResponseWrapper postJson(@Nonnull String url, @Nonnull String json, @Nonnull Map<String, String> headers) {
        return this.postJson(HttpUrl.parse(url), json, headers);
    }

    @Nonnull
    public ResponseWrapper postJson(@Nonnull String url, @Nonnull String json) {
        return this.postJson(HttpUrl.parse(url), json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper postJson(@Nonnull HttpUrl url, @Nonnull String json) {
        return this.postJson(url, json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper postJson(@Nonnull HttpUrl url, @Nonnull String json, @Nonnull Map<String, ?> headers) {
        RequestBody body = RequestBody.create(json, MediaType.parse(APPLICATION_JSON));
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        this.defaultHeaders.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(requestBuilder.build());
    }

    @Nonnull
    public ResponseWrapper putJson(@Nonnull String url, @Nonnull String json, @Nonnull Map<String, String> headers) {
        return this.putJson(HttpUrl.parse(url), json, headers);
    }

    @Nonnull
    public ResponseWrapper putJson(@Nonnull String url, @Nonnull String json) {
        return this.putJson(HttpUrl.parse(url), json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper putJson(@Nonnull HttpUrl url, @Nonnull String json) {
        return this.putJson(url, json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper putJson(@Nonnull HttpUrl url, @Nonnull String json, @Nonnull Map<String, ?> headers) {
        RequestBody body = RequestBody.create(json, MediaType.parse(APPLICATION_JSON));
        Request.Builder requestBuilder = new Request.Builder().url(url).put(body);
        this.defaultHeaders.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(requestBuilder.build());
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull String url, @Nonnull String json) {
        return this.patchJson(HttpUrl.parse(url), json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull HttpUrl url, @Nonnull String json) {
        return this.patchJson(url, json, Collections.emptyMap());
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull HttpUrl url, @Nonnull String json, @Nonnull Map<String, ?> headers) {
        Object o;
        String contentType = null;
        if (headers.containsKey(CONTENT_TYPE) && (o = headers.get(CONTENT_TYPE)) instanceof String && !((String)o).isEmpty()) {
            contentType = (String)o;
        }
        if (contentType != null) {
            return this.patchJson(url, json, contentType, headers);
        }
        return this.patchJson(url, json, APPLICATION_JSON, headers);
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull HttpUrl url, @Nonnull String json, @Nonnull String contentType, @Nonnull Map<String, ?> headers) {
        RequestBody body = RequestBody.create(json, MediaType.parse(contentType));
        Request.Builder requestBuilder = new Request.Builder().url(url).patch(body);
        this.defaultHeaders.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> requestBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(requestBuilder.build());
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull String url, @Nonnull String json, @Nonnull String contentType, @Nonnull Map<String, ?> headers) {
        return this.patchJson(HttpUrl.parse(url), json, contentType, headers);
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull String url, @Nonnull String json, @Nonnull Map<String, ?> headers) {
        HttpUrl parsedUrl = HttpUrl.parse(url);
        if (parsedUrl == null) {
            throw new HTTPWrapperException("URL parsed from String " + url + " must not be null!");
        }
        return this.patchJson(parsedUrl, json, headers);
    }

    @Nonnull
    public ResponseWrapper patchJson(@Nonnull String url, @Nonnull String json, String contentType) {
        HttpUrl parsedUrl = HttpUrl.parse(url);
        if (parsedUrl == null) {
            throw new HTTPWrapperException("URL parsed from String " + url + " must not be null!");
        }
        return this.patchJson(parsedUrl, json, contentType, Collections.emptyMap());
    }

    public ResponseWrapper delete(@Nonnull String url) {
        return this.delete(url, null, Collections.emptyMap());
    }

    public ResponseWrapper delete(@Nonnull String url, @Nonnull Map<String, ?> headers) {
        return this.delete(url, null, headers);
    }

    public ResponseWrapper delete(@Nonnull String url, @Nullable String json) {
        return this.delete(url, json, Collections.emptyMap());
    }

    public ResponseWrapper delete(@Nonnull String url, @Nullable String json, @Nonnull Map<String, ?> headers) {
        RequestBody body = json == null ? null : RequestBody.create(json, MediaType.parse(APPLICATION_JSON));
        Request.Builder reqBuilder = new Request.Builder().delete(body).url(url);
        this.defaultHeaders.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        headers.forEach((k, v) -> reqBuilder.addHeader((String)k, String.valueOf(v)));
        return this.execute(reqBuilder.build());
    }

    @Nonnull
    private ResponseWrapper execute(@Nonnull Request request) {
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            return new ResponseWrapper(response);
        }
        catch (IOException e) {
            return new ResponseWrapper(e);
        }
    }

    @Nonnull
    private HttpLoggingInterceptor createHttpLoggingInterceptor(@Nonnull HttpLoggingInterceptor.Level logLevel) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)logger).debug(arg_0));
        loggingInterceptor.redactHeader("Authorization");
        loggingInterceptor.redactHeader("Cookie");
        loggingInterceptor.setLevel(logLevel);
        return loggingInterceptor;
    }
}

