/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.cert.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.resolution.commons.cert.api.CertificateCheckResult;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SimpleCertificateCheckResultImpl
implements CertificateCheckResult {
    private final boolean valid;
    private final String message;
    private final boolean privateKey;
    private final boolean expired;
    private final X509Certificate certificate;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private static final Logger logger = LoggerFactory.getLogger(SimpleCertificateCheckResultImpl.class);

    public SimpleCertificateCheckResultImpl(X509Certificate certificate, boolean valid, boolean expired, boolean privateKey, String message) {
        this.valid = valid;
        this.expired = expired;
        this.privateKey = privateKey;
        this.message = message;
        this.certificate = certificate;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isCertSet() {
        return this.certificate != null;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    public String toString() {
        return "Valid: " + this.valid + "\n Expired:     " + this.isExpired() + "\n Set:         " + this.isCertSet() + "\n Private Key: " + this.privateKey + "\n Message:     " + this.getMessage() + "\n Readable:    " + (this.certificate == null ? "" : this.certificate.toString());
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate == null ? BigInteger.ZERO : this.certificate.getSerialNumber();
    }

    @Override
    public String getIssuerDN() {
        return this.certificate == null ? null : this.certificate.getIssuerDN().getName();
    }

    @Override
    public String getNotBefore() {
        return this.certificate == null ? null : this.dateFormat.format(this.certificate.getNotBefore());
    }

    @Override
    public String getNotAfter() {
        return this.certificate == null ? null : this.dateFormat.format(this.certificate.getNotAfter());
    }

    @Override
    public String getSubjectDN() {
        return this.certificate == null ? null : this.certificate.getSubjectDN().getName();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.certificate == null ? null : this.certificate.getPublicKey();
    }

    @Override
    public String getSigAlgName() {
        return this.certificate == null ? null : this.certificate.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate == null ? null : this.certificate.getSigAlgOID();
    }

    @Override
    public String getSignature() {
        return this.certificate == null ? null : new String(Hex.encode(this.certificate.getSignature()));
    }

    @Override
    public List<String> getSubjectAlternateNames() {
        if (this.certificate == null) {
            return null;
        }
        try {
            Collection<List<?>> sans = this.certificate.getSubjectAlternativeNames();
            if (sans == null) {
                return null;
            }
            return sans.stream().map(current -> current.stream().map(Object::toString).collect(Collectors.joining(":"))).collect(Collectors.toList());
        }
        catch (CertificateParsingException e) {
            logger.warn("Failed to read SubjectAlternateNames", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

