/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.jira;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import de.resolution.atlasuser.api.user.ApplicationAccessAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraApplicationAccessAdapter
implements ApplicationAccessAdapter {
    private final ApplicationRoleManager applicationRoleManager;
    private static final Logger logger = LoggerFactory.getLogger(JiraApplicationAccessAdapter.class);

    @Autowired
    public JiraApplicationAccessAdapter(@JiraImport ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    @Nonnull
    public Set<String> getAvailableApplicationKeys() {
        return this.applicationRoleManager.getRoles().stream().map(role -> role.getKey().toString()).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<String> getGroupsGivingAccess(String applicationKeyString) {
        if (Objects.equals(applicationKeyString, "ANY_APPLICATION")) {
            HashSet<String> ret = new HashSet<String>();
            for (String key : this.getAvailableApplicationKeys()) {
                ret.addAll(this.getGroupsGivingAccess(key));
            }
            return ret;
        }
        ApplicationRole applicationRole = this.applicationRoleManager.getRoles().stream().filter(role -> Objects.equals(role.getKey().toString(), applicationKeyString)).findFirst().orElse(null);
        if (applicationRole == null) {
            logger.debug("No applicationRole found for applicationKey {}, returning empty set.", (Object)applicationKeyString);
            return Collections.emptySet();
        }
        return applicationRole.getGroups().stream().map(Group::getName).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<String> getUsersWithDirectAccess(String applicationKey) {
        return Collections.emptySet();
    }
}

