/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.confluence;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.UserRenamingBreaksMappingValidator;
import java.util.regex.Pattern;

@ConfluenceComponent
public class ConfluenceAtlasUserValidator
extends UserRenamingBreaksMappingValidator {
    private static final Pattern illegalCharactersPattern = Pattern.compile("[\\+,\\\\<>'\"]+");

    @Override
    public void validateForCreate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForCreate(atlasUser);
        this.validateUsername(atlasUser);
    }

    @Override
    public void validateForRenaming(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForRenaming(atlasUser);
        this.validateUsername(atlasUser);
    }

    private void validateUsername(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        String username = atlasUser.get("ATTR_NEW_NAME").orElse(atlasUser.get("ATTR_NAME").orElse(null));
        if (username == null) {
            return;
        }
        if (illegalCharactersPattern.matcher(username).find()) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), "ATTR_NAME", username, " contains illegal characters. The following characters are invalid in usernames: '+', ',', '\\', '<', '>', ', or \".");
        }
    }
}

