/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.communardo;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.AutocompleteProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.MultiSelectProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.ProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.SingleSelectProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.TextBasedProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.data.UserProfileElementData;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.AutocompleteProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.MultiSelectProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.OptionedProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.ProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.SingleSelectProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.TextBasedProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.model.elements.UserProfileElement;
import de.communardo.atlassian.plugins.userprofile.external.api.service.UppProfileElementDataManager;
import de.communardo.atlassian.plugins.userprofile.external.api.service.UppProfileElementManager;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunardoUserProfileAdapterImpl
implements CommunardoUserProfileAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CommunardoUserProfileAdapterImpl.class);
    private final UppProfileElementManager profileElementManager;
    private final UppProfileElementDataManager profileElementDataManager;
    private final TransactionTemplate transactionTemplate;

    public CommunardoUserProfileAdapterImpl(TransactionTemplate transactionTemplate, ServiceTracker<?, ?> uppProfileElementManagerTracker, ServiceTracker<?, ?> uppProfileElementDataManagerTracker) {
        this.transactionTemplate = transactionTemplate;
        this.profileElementDataManager = (UppProfileElementDataManager)uppProfileElementDataManagerTracker.getService();
        this.profileElementManager = (UppProfileElementManager)uppProfileElementManagerTracker.getService();
        if (this.profileElementManager == null || this.profileElementDataManager == null) {
            throw new AtlasUserRuntimeException("UppProfileElementManager or UppProfileElementDataManager is not available");
        }
    }

    @Override
    public Map<Integer, String> getAvailableAttributes() {
        return (Map)this.transactionTemplate.execute(() -> {
            HashMap<Integer, String> retMap = new HashMap<Integer, String>();
            for (ProfileElement profileElement : this.profileElementManager.getProfileElements()) {
                retMap.put(profileElement.getId(), profileElement.getName());
            }
            return retMap;
        });
    }

    @Override
    public AtlasUserBuilder readProfileAttributes(@Nonnull String userKeyString, @Nonnull AtlasUserBuilder atlasUserBuilder) {
        this.transactionTemplate.execute(() -> {
            UserKey userKey = new UserKey(userKeyString);
            Map dataMap = this.profileElementDataManager.getProfileElementData(userKey);
            for (Map.Entry dataEntry : dataMap.entrySet()) {
                Set<String> dataAsStringSet;
                ProfileElement element = (ProfileElement)dataEntry.getKey();
                ProfileElementData data = (ProfileElementData)dataEntry.getValue();
                if (data == null || (dataAsStringSet = this.readValueAsStringSet(data)) == null) continue;
                atlasUserBuilder.with("COMMUNARDO_UP." + element.getId(), dataAsStringSet);
            }
            return null;
        });
        return atlasUserBuilder;
    }

    @Override
    public AtlasUserResultBuilder updateProfileAttributes(@Nonnull String userKeyString, @Nonnull AtlasUser atlasUser, @Nonnull AtlasUserResultBuilder atlasUserResultBuilder) {
        return (AtlasUserResultBuilder)this.transactionTemplate.execute(() -> {
            UserKey userKey = new UserKey(userKeyString);
            for (String key : atlasUser.getAttributeKeys()) {
                if (!key.startsWith("COMMUNARDO_UP.")) continue;
                int attributeId = Integer.parseInt(key.replace("COMMUNARDO_UP.", ""));
                ProfileElement profileElement = this.profileElementManager.getProfileElement(attributeId);
                if (profileElement == null) {
                    atlasUserResultBuilder.addMessage("There is no profile element with id " + attributeId);
                    continue;
                }
                try {
                    boolean changed = this.update(userKey, profileElement, atlasUser.getAttributeValues(key));
                    if (!changed || atlasUserResultBuilder.getOperation() == AtlasUserResult.Operation.ADDED) continue;
                    atlasUserResultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                }
                catch (IllegalCommunardoIdentifierException e) {
                    return atlasUserResultBuilder.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).errorString(e.getMessage());
                }
            }
            return atlasUserResultBuilder;
        });
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull ProfileElement profileElement, @Nullable Collection<String> values2) throws IllegalCommunardoIdentifierException {
        if (profileElement.getClass().equals(TextBasedProfileElement.class)) {
            return this.update(userKey, (TextBasedProfileElement)profileElement, values2);
        }
        if (profileElement.getClass().equals(AutocompleteProfileElement.class)) {
            return this.update(userKey, (AutocompleteProfileElement)profileElement, values2);
        }
        if (profileElement.getClass().equals(MultiSelectProfileElement.class)) {
            return this.update(userKey, (MultiSelectProfileElement)profileElement, values2);
        }
        if (profileElement.getClass().equals(SingleSelectProfileElement.class)) {
            return this.update(userKey, (SingleSelectProfileElement)profileElement, values2);
        }
        if (profileElement.getClass().equals(UserProfileElement.class)) {
            return this.update(userKey, (UserProfileElement)profileElement, values2);
        }
        logger.warn("ProfileElement {} is of unexpected type {}.", (Object)profileElement.getId(), (Object)profileElement.getClass().getSimpleName());
        return false;
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull TextBasedProfileElement textBasedProfileElement, @Nullable Collection<String> values2) {
        TextBasedProfileElementData data = values2 == null || values2.isEmpty() ? null : new TextBasedProfileElementData(values2.iterator().next());
        return this.profileElementDataManager.storeProfileElementData(userKey, textBasedProfileElement, data);
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull AutocompleteProfileElement autocompleteProfileElement, @Nullable Collection<String> values2) {
        AutocompleteProfileElementData data = values2 == null || values2.isEmpty() ? null : new AutocompleteProfileElementData(new HashSet<String>(values2));
        return this.profileElementDataManager.storeProfileElementData(userKey, autocompleteProfileElement, data);
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull MultiSelectProfileElement multiSelectProfileElement, @Nullable Collection<String> values2) throws IllegalCommunardoIdentifierException {
        if (values2 == null || values2.isEmpty()) {
            return this.profileElementDataManager.storeProfileElementData(userKey, multiSelectProfileElement, null);
        }
        HashMap optionMap = new HashMap();
        multiSelectProfileElement.getOptions().forEach(option -> optionMap.put(option.getId(), option));
        HashSet<OptionedProfileElement.Option> options = new HashSet<OptionedProfileElement.Option>();
        for (String currentValue : values2) {
            try {
                int optionId = Integer.parseInt(currentValue);
                if (!optionMap.containsKey(optionId)) continue;
                options.add((OptionedProfileElement.Option)optionMap.get(optionId));
            }
            catch (NumberFormatException e) {
                throw new IllegalCommunardoIdentifierException(currentValue + " cannot be parsed to a number");
            }
        }
        MultiSelectProfileElementData data = new MultiSelectProfileElementData(options);
        return this.profileElementDataManager.storeProfileElementData(userKey, multiSelectProfileElement, data);
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull SingleSelectProfileElement singleSelectProfileElement, @Nullable Collection<String> values2) throws IllegalCommunardoIdentifierException {
        if (values2 == null || values2.isEmpty()) {
            return this.profileElementDataManager.storeProfileElementData(userKey, singleSelectProfileElement, null);
        }
        String valueString = values2.iterator().next();
        try {
            int optionId = Integer.parseInt(valueString);
            Optional<OptionedProfileElement.Option> optionOpt = singleSelectProfileElement.getOptions().stream().filter(op -> op.getId() == optionId).findFirst();
            if (optionOpt.isPresent()) {
                return this.profileElementDataManager.storeProfileElementData(userKey, singleSelectProfileElement, new SingleSelectProfileElementData(optionOpt.get()));
            }
            throw new IllegalCommunardoIdentifierException(optionId);
        }
        catch (NumberFormatException e) {
            throw new IllegalCommunardoIdentifierException(valueString + " cannot be parsed to a number");
        }
    }

    public boolean update(@Nonnull UserKey userKey, @Nonnull UserProfileElement userProfileElement, @Nullable Collection<String> values2) {
        if (values2 == null || values2.isEmpty()) {
            return this.profileElementDataManager.storeProfileElementData(userKey, userProfileElement, null);
        }
        String valueString = values2.iterator().next();
        UserKey userKeyToWrite = new UserKey(valueString);
        return this.profileElementDataManager.storeProfileElementData(userKey, userProfileElement, new UserProfileElementData(userKeyToWrite));
    }

    @Nullable
    public Set<String> readValueAsStringSet(ProfileElementData<?> profileElementData) {
        if (profileElementData instanceof TextBasedProfileElementData) {
            TextBasedProfileElementData data = (TextBasedProfileElementData)profileElementData;
            String text = data.getText();
            if (text != null) {
                return Collections.singleton(text);
            }
            return null;
        }
        if (profileElementData instanceof AutocompleteProfileElementData) {
            AutocompleteProfileElementData data = (AutocompleteProfileElementData)profileElementData;
            if (data.getValues().isEmpty()) {
                return null;
            }
            return new HashSet<String>(data.getValues());
        }
        if (profileElementData instanceof MultiSelectProfileElementData) {
            MultiSelectProfileElementData data = (MultiSelectProfileElementData)profileElementData;
            if (data.getOptions().isEmpty()) {
                return null;
            }
            return data.getOptions().stream().map(it -> String.valueOf(it.getId())).collect(Collectors.toSet());
        }
        if (profileElementData instanceof SingleSelectProfileElementData) {
            SingleSelectProfileElementData data = (SingleSelectProfileElementData)profileElementData;
            if (data.getOption() == null) {
                return null;
            }
            return Collections.singleton(String.valueOf(data.getOption().getId()));
        }
        if (profileElementData instanceof UserProfileElementData) {
            UserProfileElementData data = (UserProfileElementData)profileElementData;
            UserKey key = data.getUserKey();
            if (key != null) {
                return Collections.singleton(data.getUserKey().getStringValue());
            }
            return null;
        }
        return Collections.singleton(profileElementData.toString());
    }

    private static class IllegalCommunardoIdentifierException
    extends Exception {
        public IllegalCommunardoIdentifierException(String message) {
            super(message);
        }

        public IllegalCommunardoIdentifierException(int identifier) {
            super("No Communardo-identifier " + identifier + " available");
        }
    }
}

