/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.bitbucket;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.atlasuser.impl.user.PermissionChecker;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketPermissionChecker
implements PermissionChecker {
    private final SecurityService securityService;
    private final UserService userService;
    private final PermissionService permissionService;

    @Autowired
    public BitbucketPermissionChecker(@BitbucketImport SecurityService securityService, @BitbucketImport UserService userService, @BitbucketImport PermissionService permissionService) {
        this.securityService = securityService;
        this.userService = userService;
        this.permissionService = permissionService;
    }

    @Override
    public boolean isAdmin(@Nonnull String username) throws UserNotFoundException {
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Check admin permission for user").call(() -> {
            ApplicationUser applicationUser = this.userService.getUserByName(username, true);
            if (applicationUser != null) {
                return this.permissionService.hasGlobalPermission(applicationUser, Permission.ADMIN);
            }
            throw new UserNotFoundException("Could not load userProfile for " + username);
        });
    }

    @Override
    public boolean isSysAdmin(@Nonnull String username) throws UserNotFoundException {
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Check sysadmin permission for user").call(() -> {
            ApplicationUser applicationUser = this.userService.getUserByName(username, true);
            if (applicationUser != null) {
                return this.permissionService.hasGlobalPermission(applicationUser, Permission.SYS_ADMIN);
            }
            throw new UserNotFoundException("Could not load userProfile for " + username);
        });
    }
}

