/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.bitbucket;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.model.user.User;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.atlasuser.api.HostProduct;
import de.resolution.atlasuser.api.HostProductProvider;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketApplicationAttributeAdapter
implements ApplicationAttributeAdapter,
HostProductProvider {
    private final SecurityService securityService;
    private final UserService userService;
    private final UserAdminService userAdminService;

    @Autowired
    public BitbucketApplicationAttributeAdapter(@BitbucketImport SecurityService securityService, @BitbucketImport UserService userService, @BitbucketImport UserAdminService userAdminService) {
        this.securityService = securityService;
        this.userService = userService;
        this.userAdminService = userAdminService;
    }

    @Override
    public HostProduct getHostProduct() {
        return HostProduct.BITBUCKET;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public String getUsernameForKey(@Nonnull String key) {
        int id = Integer.parseInt(key);
        ApplicationUser applicationUser = this.userService.getUserById(id, true);
        if (applicationUser == null) {
            return null;
        }
        return applicationUser.getName();
    }

    @Override
    public AtlasUserResultBuilder updateApplicationAttributes(User crowdUser, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder) {
        return resultBuilder;
    }

    @Override
    public AtlasUserBuilder readApplicationAttributes(User crowdUser, AtlasUserBuilder atlasUserBuilder, @Nullable Collection<String> knownKeys) {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Read Bitbucket id of user").call(() -> {
            ApplicationUser applicationUser = this.userService.getUserByName(crowdUser.getName(), true);
            if (applicationUser != null) {
                atlasUserBuilder.with("ATTR_USER_KEY", String.valueOf(applicationUser.getId()));
                DetailedUser detailedUser = this.userAdminService.getUserDetails(applicationUser);
                Date lastAuthentication = detailedUser.getLastAuthenticationTimestamp();
                if (lastAuthentication != null) {
                    atlasUserBuilder.with("ATTR_BITBUCKET_LAST_AUTHENTICATED", String.valueOf(lastAuthentication.getTime()));
                }
            }
            return null;
        });
        return atlasUserBuilder;
    }

    @Override
    public long getLastAuthenticatedFromApplicationLevel(User crowdUser) {
        return (Long)this.securityService.withPermission(Permission.SYS_ADMIN, "Read last authentication timestamp").call(() -> {
            DetailedUser detailedUser;
            Date lastAuthentication;
            ApplicationUser applicationUser = this.userService.getUserByName(crowdUser.getName(), true);
            if (applicationUser != null && (lastAuthentication = (detailedUser = this.userAdminService.getUserDetails(applicationUser)).getLastAuthenticationTimestamp()) != null) {
                return lastAuthentication.getTime();
            }
            return AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
        });
    }
}

