/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.impl.user.AbstractAttributeFilter;
import de.resolution.commons.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringAttributeFilter
extends AbstractAttributeFilter {
    private static final Logger logger = LoggerFactory.getLogger(StringAttributeFilter.class);
    private final String compareToValue;

    private StringAttributeFilter(String compareToValue, String ... attributeNames) {
        super(attributeNames);
        this.compareToValue = compareToValue;
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    protected abstract boolean test(@Nullable String var1, String var2);

    @Override
    public boolean test(Map<String, Set<String>> valueMap) {
        for (String key : this.getAttributeNames()) {
            Set<String> values2 = valueMap.get(key);
            if (values2 != null && !values2.isEmpty()) {
                return this.test(values2.iterator().next(), this.compareToValue);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Skipping empty value for key {} compare to {} ", (Object)key, (Object)StringUtil.sanitize(this.compareToValue));
        }
        return false;
    }

    public static class EqualsStringAttributeFilter
    extends StringAttributeFilter {
        public EqualsStringAttributeFilter(String compareToValue, String ... attributeNames) {
            super(compareToValue, attributeNames);
        }

        @Override
        public boolean test(@Nullable String attributeValue, String compareToValue) {
            if (attributeValue == null) {
                return false;
            }
            return attributeValue.equals(compareToValue);
        }
    }
}

