/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.api.exception.InvalidAtlasUserStateException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AtlasUserBuilder {
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();
    private String findByAttributeName;
    private String findByAttributeValue;
    private long directoryId = -2L;

    public AtlasUserBuilder() {
        this.active(true);
    }

    @Nonnull
    public Optional<Set<String>> get(@Nonnull String key) {
        Set<String> values2 = this.attributes.get(key);
        if (values2 == null) {
            return Optional.empty();
        }
        return Optional.of(new HashSet<String>(values2));
    }

    @Nullable
    public String getFirstIfPresent(@Nonnull String key) {
        Set<String> values2 = this.attributes.get(key);
        if (values2 != null) {
            if (values2.isEmpty()) {
                return null;
            }
            return values2.iterator().next();
        }
        return null;
    }

    public AtlasUserBuilder from(AtlasUser atlasUser) {
        this.findByAttributeName = atlasUser.getReference().getFindByAttributeName();
        this.findByAttributeValue = atlasUser.getReference().getFindByAttributeValue();
        this.directoryId = atlasUser.getReference().getDirectoryId();
        Map<String, Set<String>> otherAttributes = atlasUser.getAttributes();
        otherAttributes.keySet().forEach(key -> this.attributes.put((String)key, new HashSet((Collection)otherAttributes.get(key))));
        return this;
    }

    public AtlasUserBuilder findBy(String findByAttributeName, Object findByAttributeValue) {
        this.findByAttributeName = findByAttributeName;
        this.findByAttributeValue = String.valueOf(findByAttributeValue);
        return this;
    }

    public AtlasUserBuilder findBy(@Nonnull AtlasUserReference atlasUserId) {
        this.directoryId = atlasUserId.getDirectoryId();
        this.findByAttributeName = atlasUserId.getFindByAttributeName();
        this.findByAttributeValue = atlasUserId.getFindByAttributeValue();
        return this;
    }

    public AtlasUserBuilder in(long directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public AtlasUserBuilder with(@Nonnull String key, Object ... values2) {
        if (values2.length == 0) {
            this.attributes.put(key, Collections.emptySet());
        } else {
            this.attributes.put(key, new HashSet(Arrays.stream(values2).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toSet())));
        }
        return this;
    }

    public AtlasUserBuilder with(@Nonnull String key, @Nonnull Collection<?> values2) {
        this.attributes.put(key, new HashSet(values2.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toSet())));
        return this;
    }

    public AtlasUserBuilder with(@Nonnull String key, boolean value) {
        this.attributes.put(key, Collections.singleton(String.valueOf(value)));
        return this;
    }

    public AtlasUserBuilder active(boolean active) {
        return this.with("ATTR_ACTIVE", String.valueOf(active));
    }

    public AtlasUserBuilder without(@Nonnull String key) {
        this.attributes.remove(key);
        return this;
    }

    public AtlasUser build() {
        if (this.findByAttributeName == null || this.findByAttributeName.isEmpty()) {
            throw new InvalidAtlasUserStateException("findByAttributeName must not be null or empty");
        }
        if (this.findByAttributeValue == null || this.findByAttributeValue.isEmpty()) {
            throw new InvalidAtlasUserStateException("findByAttributeValue for " + this.findByAttributeName + " must not be null or empty");
        }
        if (this.directoryId == -2L) {
            throw new InvalidAtlasUserStateException("Directory reference must not be -2");
        }
        return new ImmutableAtlasUser(AtlasUserReference.create(this.findByAttributeName, this.findByAttributeValue, this.directoryId), this.attributes);
    }
}

