/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.impl.user.ProfilePictureAdapter;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfilePictureAdapter
implements ProfilePictureAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProfilePictureAdapter.class);
    protected static final String FILENAME_PREFIX = "atlas-user-";

    @Nonnull
    protected String getFilename(@Nonnull String hash) {
        String fileName = FILENAME_PREFIX + this.stripIllegalCharacters(hash);
        logger.debug("Filename of avatar is: {}", (Object)fileName);
        return fileName;
    }

    @Nonnull
    private String stripIllegalCharacters(@Nonnull String hash) {
        return hash.replaceAll("W/\"(.*)\"", "$1").replaceAll("[^a-zA-Z0-9]", "");
    }

    @Nonnull
    protected String detectMimeType(@Nonnull String avatarBase64) throws IOException {
        if (avatarBase64.startsWith("i")) {
            return "image/png";
        }
        if (avatarBase64.startsWith("/")) {
            return "image/jpeg";
        }
        if (avatarBase64.startsWith("R")) {
            return "image/gif";
        }
        throw new IOException("Illegal MIME type. The following MIME types are supported: {}" + String.join((CharSequence)",", SUPPORTED_MIME_TYPES));
    }
}

